package com.yunyinsign.api.sdk.util;

import com.alibaba.fastjson.JSON;
import com.yunyinsign.api.sdk.BaseObject;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpUtil {
    private static final OkHttpClient client = new OkHttpClient.Builder()
            .connectTimeout(10, TimeUnit.SECONDS)
            .readTimeout(30, TimeUnit.SECONDS)
            .build();

    private static final MediaType JSON_TYPE = MediaType.parse("application/json; charset=utf-8");

    /**
     * GET请求
     */
    public static <T extends BaseObject> T get(String url, Object params, Class<T> clazz) {
        try {
            // 构建查询参数
            HttpUrl.Builder urlBuilder = HttpUrl.parse(url).newBuilder();
            if (params != null) {
                Map<String, Object> paramMap = JSON.parseObject(JSON.toJSONString(params), Map.class);
                paramMap.forEach((k, v) -> {
                    if (v != null) {
                        urlBuilder.addQueryParameter(k, v.toString());
                    }
                });
            }

            Request request = new Request.Builder()
                    .url(urlBuilder.build())
                    .get()
                    .build();

            Response response = client.newCall(request).execute();
            return JSON.parseObject(response.body().string(), clazz);
        } catch (IOException e) {
            throw new RuntimeException("HTTP request failed", e);
        }
    }

    /**
     * POST请求
     */
    public static <T extends BaseObject> T post(String url, Object params, Class<T> clazz) {
        try {
            RequestBody body = RequestBody.create(
                    JSON.toJSONString(params),
                    JSON_TYPE
            );

            Request request = new Request.Builder()
                    .url(url)
                    .post(body)
                    .build();

            Response response = client.newCall(request).execute();
            return JSON.parseObject(response.body().string(), clazz);
        } catch (IOException e) {
            throw new RuntimeException("HTTP request failed", e);
        }
    }

    // 简化版本，返回字符串
    public static String get(String url, Object params) {
        try {
            HttpUrl.Builder urlBuilder = HttpUrl.parse(url).newBuilder();
            if (params != null) {
                Map<String, Object> paramMap = JSON.parseObject(JSON.toJSONString(params), Map.class);
                paramMap.forEach((k, v) -> {
                    if (v != null) {
                        urlBuilder.addQueryParameter(k, v.toString());
                    }
                });
            }

            Request request = new Request.Builder()
                    .url(urlBuilder.build())
                    .get()
                    .build();

            Response response = client.newCall(request).execute();
            return response.body().string();
        } catch (IOException e) {
            throw new RuntimeException("HTTP request failed", e);
        }
    }

    public static String post(String url, Object params) {
        try {
            RequestBody body = RequestBody.create(
                    JSON.toJSONString(params),
                    JSON_TYPE
            );

            Request request = new Request.Builder()
                    .url(url)
                    .post(body)
                    .build();

            Response response = client.newCall(request).execute();
            return response.body().string();
        } catch (IOException e) {
            throw new RuntimeException("HTTP request failed", e);
        }
    }
}
