package com.yunyinsign.api.sdk.result.template;

import com.yunyinsign.api.sdk.core.BasePageResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;

import java.time.LocalDateTime;


/**
 * @author dyl
 */
public class TemplateListRes extends BasePageResponse {

    /**
    * 模板ID
     */
    @ApiField("templateId")
    private Long templateId;
    /**
     * 模板编码
     */
    @ApiField("templateCode")
    private String templateCode;
    /**
     * 模板名称
     */
    @ApiField("templateName")
    private String templateName;
    /**
     * 模板状态:0 - 停用状态; 1 - 启用状态
     */
    @ApiField("templateStatus")
    private Integer templateStatus;
    /**
     * 企业名称
     */
    @ApiField("corpName")
    private String corpName;
    /**
     * 是否加密合同(0: 普通合同；1：加密合同). 默认加密合同，区别：加密合同需要登录才能看到合同；普通合同分享给对方可以不需要登录就可以看到合同内容，签署完成后自动变为加密合同
     */
    @ApiField("encryptFlag")
    private Integer encryptFlag;
    /**
     * 模板创建时间
     */
    @ApiField("createTime")
    private LocalDateTime createTime;
    /**
     * 模板最后更新时间
     */
    @ApiField("updateTime")
    private LocalDateTime updateTime;
    /**
     * 模板创建人
     */
    @ApiField("createName")
    private String createName;
    /**
     * 模板最后更新人
     */
    @ApiField("updateName")
    private String updateName;

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Integer getTemplateStatus() {
        return templateStatus;
    }

    public void setTemplateStatus(Integer templateStatus) {
        this.templateStatus = templateStatus;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public Integer getEncryptFlag() {
        return encryptFlag;
    }

    public void setEncryptFlag(Integer encryptFlag) {
        this.encryptFlag = encryptFlag;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }
}
