package com.yunyinsign.api.sdk.result.template;

import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;
import com.yunyinsign.api.sdk.result.GetTemplateAttachmentRes;
import com.yunyinsign.api.sdk.result.GetTemplateContractFileRes;
import com.yunyinsign.api.sdk.result.GetTemplateCopierRes;
import com.yunyinsign.api.sdk.result.GetTemplateParticipantRes;


import java.time.LocalDateTime;
import java.util.List;


public class TemplateInfoRes extends BaseResponse {

    /** 模板ID */
    @ApiField("templateId")
    private Long templateId;
    /** 企业名称 */
    @ApiField("corpName")
    private String corpName;
    /** 模板编码 */
    @ApiField("templateCode")
    private String templateCode;
    /** 模板名称 */
    @ApiField("templateName")
    private String templateName;
    /** 模板状态:0 - 停用状态; 1 - 启用状态 */
    @ApiField("templateStatus")
    private Integer templateStatus;
    /** 是否加密合同(0: 普通合同；1：加密合同). 默认加密合同，区别：加密合同需要登录才能看到合同；普通合同分享给对方可以不需要登录就可以看到合同内容，签署完成后自动变为加密合同 */
    @ApiField("encryptFlag")
    private Integer encryptFlag;
    /** 模板创建时间 */
    @ApiField("createTime")
    private LocalDateTime createTime;
    /** 模板更新时间 */
    @ApiField("updateTime")
    private LocalDateTime updateTime;
    /** 模板创建人 */
    @ApiField("createName")
    private String createName;
    /** 模板最后更新人 */
    @ApiField("updateName")
    private String updateName;


    /** 合同文件 */
    @ApiField("contractFileList")
    private List<GetTemplateContractFileRes> contractFileList;

    /** 参与方 */
    @ApiField("participantList")
    private List<GetTemplateParticipantRes> participantList;

    /** 抄送方 */
    @ApiField("copierList")
    private List<GetTemplateCopierRes> copierList;

    /** 附件 */
    @ApiField("attachmentList")
    private List<GetTemplateAttachmentRes> attachmentList;

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Integer getTemplateStatus() {
        return templateStatus;
    }

    public void setTemplateStatus(Integer templateStatus) {
        this.templateStatus = templateStatus;
    }

    public Integer getEncryptFlag() {
        return encryptFlag;
    }

    public void setEncryptFlag(Integer encryptFlag) {
        this.encryptFlag = encryptFlag;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }

    public List<GetTemplateContractFileRes> getContractFileList() {
        return contractFileList;
    }

    public void setContractFileList(List<GetTemplateContractFileRes> contractFileList) {
        this.contractFileList = contractFileList;
    }

    public List<GetTemplateParticipantRes> getParticipantList() {
        return participantList;
    }

    public void setParticipantList(List<GetTemplateParticipantRes> participantList) {
        this.participantList = participantList;
    }

    public List<GetTemplateCopierRes> getCopierList() {
        return copierList;
    }

    public void setCopierList(List<GetTemplateCopierRes> copierList) {
        this.copierList = copierList;
    }

    public List<GetTemplateAttachmentRes> getAttachmentList() {
        return attachmentList;
    }

    public void setAttachmentList(List<GetTemplateAttachmentRes> attachmentList) {
        this.attachmentList = attachmentList;
    }
}
