package com.yunyinsign.api.sdk.result.template;


import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;
import com.yunyinsign.api.sdk.result.GetParticipantInfoRes;
import com.yunyinsign.api.sdk.result.GetTemplateComponentRes;


import java.util.List;


public class TemplateComponentInfoRes extends BaseResponse {

    /**
     * 公司ID
     */
    @ApiField("corpId")
    private Long corpId;
    /**
     * 模板ID
     */
    @ApiField("templateId")
    private Long templateId;
    /**
     * 文件ID
     */
    @ApiField("fileId")
    private Long fileId;
    /**
     * 文件名称
     */
    @ApiField("fileName")
    private String fileName;
    /**
     * 总页数
     */
    @ApiField("totalPage")
    private Integer totalPage;
    /**
     * 页宽
     */
    @ApiField("width")
    private Integer width;
    /**
     * 页高
     */
    @ApiField("height")
    private Integer height;
    /**
     * 分割的jpg文件
     */
    @ApiField("jpgUrlList")
    private List<String> jpgUrlList;
    /**
     * 账户余额
     */
    @ApiField("accountBalance")
    private Integer accountBalance;

    /**
     * 参与方
     */
    @ApiField("participantList")
    private List<GetParticipantInfoRes> participantList;

    /**
     * 组件信息
     */
    @ApiField("componentList")
    private List<GetTemplateComponentRes> componentList;

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getTotalPage() {
        return totalPage;
    }

    public void setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public List<String> getJpgUrlList() {
        return jpgUrlList;
    }

    public void setJpgUrlList(List<String> jpgUrlList) {
        this.jpgUrlList = jpgUrlList;
    }

    public Integer getAccountBalance() {
        return accountBalance;
    }

    public void setAccountBalance(Integer accountBalance) {
        this.accountBalance = accountBalance;
    }

    public List<GetParticipantInfoRes> getParticipantList() {
        return participantList;
    }

    public void setParticipantList(List<GetParticipantInfoRes> participantList) {
        this.participantList = participantList;
    }

    public List<GetTemplateComponentRes> getComponentList() {
        return componentList;
    }

    public void setComponentList(List<GetTemplateComponentRes> componentList) {
        this.componentList = componentList;
    }
}
