package com.yunyinsign.api.sdk.result.sign;


import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;



/**
 * 提交合同返回结果.
 * @author
 */


public class SignFlowProcessRes extends BaseResponse {

    /**
     * 合同流程ID
     */
    @ApiField("flowId")
    private Long flowId;
    /**
     * 当前流程状态: 0 - 草稿; 1 - 签署中; 2 - 完成; 3 - 撤销; 5 - 过期（签署截至日期到期后触发; 6 - 拒签
     */
    @ApiField("flowStatus")
    private Integer flowStatus;
    /**
     * 签署流程描述: 如果流程已拒签或已撤销，并且存在拒签或撤回原因，流程描述显示为原因,，否则默认为流程状态描述
     */
    @ApiField("flowDesc")
    private String flowDesc;
    /**
     * 流程标题
     */
    @ApiField("flowTitle")
    private String flowTitle;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public Integer getFlowStatus() {
        return flowStatus;
    }

    public void setFlowStatus(Integer flowStatus) {
        this.flowStatus = flowStatus;
    }

    public String getFlowDesc() {
        return flowDesc;
    }

    public void setFlowDesc(String flowDesc) {
        this.flowDesc = flowDesc;
    }

    public String getFlowTitle() {
        return flowTitle;
    }

    public void setFlowTitle(String flowTitle) {
        this.flowTitle = flowTitle;
    }
}

