package com.yunyinsign.api.sdk.result.sign;

import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;

import java.util.List;

public class GetSignerInfoRes  extends BaseResponse {

    /**
     * 参与方ID
     */
    @ApiField("participantId")
    private Long participantId;
    /**
     * 参与方标识
     */
    @ApiField("participantFlag")
    private String participantFlag;
    /**
     * 参与方类型 1-企业 0-个人
     */
    @ApiField("participantType")
    private Integer participantType;
    /**
     * 参与方式：1-填写 2-签署；用英文逗号分隔
     */
    @ApiField("participateBizType")
    private List<String> participateBizType;
    /**
     * 企业经办人账号ID
     */
    @ApiField("psnId")
    private Long psnId;
    /**
     * 经办人名称
     */
    @ApiField("psnName")
    private String psnName;
    /**
     * 企业id（个人类型时为空）
     */
    @ApiField("participantCorpId")
    private Long ParticipantCorpId;
    /**
     * 企业名称（个人类型时为空）
     */
    @ApiField("participantCorpName")
    private String ParticipantCorpName;
    /**
     * 是否需要收款（0：否；1：是）
     */
    @ApiField("payeeContractFlag")
    private Integer payeeContractFlag;

    /**
     * 收款信息
     */
    @ApiField("payee")
    private GetSignFlowPayeeRes payee;
    /**
     * 印章信息.
     */
    @ApiField("sealList")
    private List<GetSignSealInfoRes> sealList;

    public Long getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public String getParticipantFlag() {
        return participantFlag;
    }

    public void setParticipantFlag(String participantFlag) {
        this.participantFlag = participantFlag;
    }

    public Integer getParticipantType() {
        return participantType;
    }

    public void setParticipantType(Integer participantType) {
        this.participantType = participantType;
    }

    public List<String> getParticipateBizType() {
        return participateBizType;
    }

    public void setParticipateBizType(List<String> participateBizType) {
        this.participateBizType = participateBizType;
    }

    public Long getPsnId() {
        return psnId;
    }

    public void setPsnId(Long psnId) {
        this.psnId = psnId;
    }

    public String getPsnName() {
        return psnName;
    }

    public void setPsnName(String psnName) {
        this.psnName = psnName;
    }

    public Long getParticipantCorpId() {
        return ParticipantCorpId;
    }

    public void setParticipantCorpId(Long participantCorpId) {
        ParticipantCorpId = participantCorpId;
    }

    public String getParticipantCorpName() {
        return ParticipantCorpName;
    }

    public void setParticipantCorpName(String participantCorpName) {
        ParticipantCorpName = participantCorpName;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public GetSignFlowPayeeRes getPayee() {
        return payee;
    }

    public void setPayee(GetSignFlowPayeeRes payee) {
        this.payee = payee;
    }

    public List<GetSignSealInfoRes> getSealList() {
        return sealList;
    }

    public void setSealList(List<GetSignSealInfoRes> sealList) {
        this.sealList = sealList;
    }
}
