package com.yunyinsign.api.sdk.result.sign;

import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;
import com.yunyinsign.api.sdk.result.SignFlowContractFileRes;


import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


public class GetSignFlowTaskInfoRes extends BaseResponse {

    /**
     * 流程ID
     */
    @ApiField("flowId")
    private Long flowId;
    /**
     * 文件主题（签署流程标题）
     */
    @ApiField("flowTitle")
    private String FlowTitle;
    /**
     * 截止时间
     */
    @ApiField("expireDate")
    private LocalDateTime expireDate;
    /**
     * 当前流程状态: 0 - 草稿; 1 - 签署中; 2 - 完成; 3 - 撤销; 5 - 过期（签署截至日期到期后触发; 6 - 拒签
     */
    @ApiField("flowStatus")
    private Integer flowStatus;
    /**
     * 签署流程描述
     */
    @ApiField("flowDesc")
    private String flowDesc;
    /**
     * 签署流程开启时间
     */
    @ApiField("flowStartTime")
    private LocalDateTime flowStartTime;
    /**
     * 签署流程结束时间
     */
    @ApiField("flowFinishTime")
    private LocalDateTime flowFinishTime;
    /**
     * 操作状态：(1 - 填写;  2 - 签署;  3 - 催办;  4 - 查看;)
     */
    @ApiField("operateStatus")
    private Integer operateStatus;
    /**
     * 企业ID
     */
    @ApiField("corpId")
    private Long corpId;
    /**
     * 公司名称
     */
    @ApiField("corpName")
    private String corpName;
    /**
     * 发起人Id
     */
    @ApiField("initiatorId")
    private String initiatorId;
    /**
     * 发起人名称
     */
    @ApiField("initiatorName")
    private String initiatorName;
    /**
     * 发起方类型(0：个人；1：企业)
     */
    @ApiField("initiatorType")
    private Integer initiatorType;
    /**
     * 模板ID
     */
    @ApiField("templateId")
    private Long templateId;
    /**
     * 是否加密合同(0: 普通合同；1：加密合同)
     */
    @ApiField("encryptFlag")
    private Integer encryptFlag;
    /**
     * 是否对方付（0：发起方付；1：对方付）
     */
    @ApiField("reversePayFlag")
    private Integer reversePayFlag;
    /**
     * 合同费用支付状态（0：未支付；1：已支付）
     */
    @ApiField("feePayFlag")
    private Integer feePayFlag;
    /**
     * 是否收款合同（0：否；1：收款合同）
     */
    @ApiField("payeeContractFlag")
    private Integer payeeContractFlag;
    /**
     * 收款总金额
     */
    @ApiField("totalAmount")
    private BigDecimal totalAmount;
    /**
     * 创建时间
     */
    @ApiField("createTime")
    private LocalDateTime createTime;
    /**
     * 签署方 集合
     */
    @ApiField("participantList")
    private List<GetSignFlowSignerRes> participantList;
    /**
     * 合同文件集合
     */
    @ApiField("contractFileList")
    private List<SignFlowContractFileRes> contractFileList;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public String getFlowTitle() {
        return FlowTitle;
    }

    public void setFlowTitle(String flowTitle) {
        FlowTitle = flowTitle;
    }

    public LocalDateTime getExpireDate() {
        return expireDate;
    }

    public void setExpireDate(LocalDateTime expireDate) {
        this.expireDate = expireDate;
    }

    public Integer getFlowStatus() {
        return flowStatus;
    }

    public void setFlowStatus(Integer flowStatus) {
        this.flowStatus = flowStatus;
    }

    public String getFlowDesc() {
        return flowDesc;
    }

    public void setFlowDesc(String flowDesc) {
        this.flowDesc = flowDesc;
    }

    public LocalDateTime getFlowStartTime() {
        return flowStartTime;
    }

    public void setFlowStartTime(LocalDateTime flowStartTime) {
        this.flowStartTime = flowStartTime;
    }

    public LocalDateTime getFlowFinishTime() {
        return flowFinishTime;
    }

    public void setFlowFinishTime(LocalDateTime flowFinishTime) {
        this.flowFinishTime = flowFinishTime;
    }

    public Integer getOperateStatus() {
        return operateStatus;
    }

    public void setOperateStatus(Integer operateStatus) {
        this.operateStatus = operateStatus;
    }

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public String getInitiatorId() {
        return initiatorId;
    }

    public void setInitiatorId(String initiatorId) {
        this.initiatorId = initiatorId;
    }

    public String getInitiatorName() {
        return initiatorName;
    }

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public Integer getInitiatorType() {
        return initiatorType;
    }

    public void setInitiatorType(Integer initiatorType) {
        this.initiatorType = initiatorType;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Integer getEncryptFlag() {
        return encryptFlag;
    }

    public void setEncryptFlag(Integer encryptFlag) {
        this.encryptFlag = encryptFlag;
    }

    public Integer getReversePayFlag() {
        return reversePayFlag;
    }

    public void setReversePayFlag(Integer reversePayFlag) {
        this.reversePayFlag = reversePayFlag;
    }

    public Integer getFeePayFlag() {
        return feePayFlag;
    }

    public void setFeePayFlag(Integer feePayFlag) {
        this.feePayFlag = feePayFlag;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public List<GetSignFlowSignerRes> getParticipantList() {
        return participantList;
    }

    public void setParticipantList(List<GetSignFlowSignerRes> participantList) {
        this.participantList = participantList;
    }

    public List<SignFlowContractFileRes> getContractFileList() {
        return contractFileList;
    }

    public void setContractFileList(List<SignFlowContractFileRes> contractFileList) {
        this.contractFileList = contractFileList;
    }
}
