package com.yunyinsign.api.sdk.result.sign;


import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;




import java.time.LocalDateTime;

public class GetSignFlowSignerRes extends BaseResponse {

    /**
     * 签署人信息ID
     */
    @ApiField("participantId")
    private Long participantId;
    /**
     * 经办人id
     */
    @ApiField("psnId")
    private Long psnId;
    /**
     * 经办人名称
     */
    @ApiField("psnName")
    private String psnName;
    /**
     * 企业名称（个人类型时为空）
     */
    @ApiField("participantCorpName")
    private String ParticipantCorpName;
    /**
     * 经办人手机
     */
    @ApiField("psnAccount")
    private String psnAccount;
    /**
     * 参与方类型 1-企业 0-个人
     */
    @ApiField("participantType")
    private Integer participantType;
    /**
     * 参与方式：1-填写 2-签署；用英文逗号分隔
     */
    @ApiField("participateBizType")
    private String participateBizType;
    /**
     * 参与方式：1-填写 2-签署; 3-付款；
     */
    @ApiField("participateBizTypeFillOrSign")
    private Integer participateBizTypeFillOrSign;
    /**
     * 当前记录是否等待我操作 true=待我处理；false=其他人处理，或者已经处理完毕
     */
    @ApiField("isWaitForMeToDo")
    private boolean isWaitForMeToDo;
    /**
     * 当前签署状态:    1 - 填写中;  2 - 签署中; 3 - 已签署;  4 - 等待审批; 5 - 已拒签
     */
    @ApiField("signStatus")
    private Integer signStatus;
    /**
     * 填写顺序，默认值1： 1-255 不同参与人不可重复
     */
    @ApiField("draftSort")
    private Integer draftSort;
    /**
     * 签署顺序，默认值1： 1-255 不同参与人可重复
     */
    @ApiField("signOrder")
    private Integer signOrder;
    /**
     * 参与企业CorpId
     */
    @ApiField("participantCorpId")
    private Long participantCorpId;
    /**
     * 当前流程，处理的状态， did（完成）， do(正在做)， will do（计划要做）
     */
    @ApiField("dongStatus")
    private String dongStatus;
    /**
     * 填写时间
     */
    @ApiField("draftTime")
    private LocalDateTime draftTime;
    /**
     * 签署时间
     */
    @ApiField("signTime")
    private LocalDateTime signTime;
    /**
     * 是否收款合同（0：否；1：收款合同）
     */
    @ApiField("payeeContractFlag")
    private Integer payeeContractFlag;
    /**
     * 支付信息
     */
    @ApiField("payee")
    private GetSignFlowPayeeRes payee;

    public Long getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public Long getPsnId() {
        return psnId;
    }

    public void setPsnId(Long psnId) {
        this.psnId = psnId;
    }

    public String getPsnName() {
        return psnName;
    }

    public void setPsnName(String psnName) {
        this.psnName = psnName;
    }

    public String getParticipantCorpName() {
        return ParticipantCorpName;
    }

    public void setParticipantCorpName(String participantCorpName) {
        ParticipantCorpName = participantCorpName;
    }

    public String getPsnAccount() {
        return psnAccount;
    }

    public void setPsnAccount(String psnAccount) {
        this.psnAccount = psnAccount;
    }

    public Integer getParticipantType() {
        return participantType;
    }

    public void setParticipantType(Integer participantType) {
        this.participantType = participantType;
    }

    public String getParticipateBizType() {
        return participateBizType;
    }

    public void setParticipateBizType(String participateBizType) {
        this.participateBizType = participateBizType;
    }

    public Integer getParticipateBizTypeFillOrSign() {
        return participateBizTypeFillOrSign;
    }

    public void setParticipateBizTypeFillOrSign(Integer participateBizTypeFillOrSign) {
        this.participateBizTypeFillOrSign = participateBizTypeFillOrSign;
    }

    public boolean getIsWaitForMeToDo() {
        return isWaitForMeToDo;
    }

    public void setIsWaitForMeToDo(boolean waitForMeToDo) {
        isWaitForMeToDo = waitForMeToDo;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public Integer getDraftSort() {
        return draftSort;
    }

    public void setDraftSort(Integer draftSort) {
        this.draftSort = draftSort;
    }

    public Integer getSignOrder() {
        return signOrder;
    }

    public void setSignOrder(Integer signOrder) {
        this.signOrder = signOrder;
    }

    public Long getParticipantCorpId() {
        return participantCorpId;
    }

    public void setParticipantCorpId(Long participantCorpId) {
        this.participantCorpId = participantCorpId;
    }

    public String getDongStatus() {
        return dongStatus;
    }

    public void setDongStatus(String dongStatus) {
        this.dongStatus = dongStatus;
    }

    public LocalDateTime getDraftTime() {
        return draftTime;
    }

    public void setDraftTime(LocalDateTime draftTime) {
        this.draftTime = draftTime;
    }

    public LocalDateTime getSignTime() {
        return signTime;
    }

    public void setSignTime(LocalDateTime signTime) {
        this.signTime = signTime;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public GetSignFlowPayeeRes getPayee() {
        return payee;
    }

    public void setPayee(GetSignFlowPayeeRes payee) {
        this.payee = payee;
    }
}
