package com.yunyinsign.api.sdk.result.sign;


import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;
import com.yunyinsign.api.sdk.result.pay.GetPayChannelBaseInfoRes;


import java.math.BigDecimal;
import java.util.List;


public class GetSignFlowSignerPayInfoRes extends BaseResponse {

    /**
     * 签署流程信息ID
     */
    @ApiField("flowId")
    private Long flowId;
    /**
     * 签署参与方ID
     */
    @ApiField("participantId")
    private Long participantId;
    /**
     * 签署流程标题
     */
    @ApiField("flowTitle")
    private String flowTitle;
    /**
     * 收款经办人id
     */
    @ApiField("psnId")
    private Long psnId;
    /**
     * 收款经办人名称
     */
    @ApiField("psnName")
    private String psnName;
    /**
     * 收款参与企业CorpId
     */
    @ApiField("participantCorpId")
    private Long participantCorpId;
    /**
     * 收款企业名称（个人类型时为空）
     */
    @ApiField("participantCorpName")
    private String ParticipantCorpName;
    /**
     * 收款经办人手机
     */
    @ApiField("psnAccount")
    private String psnAccount;
    /**
     * 收款金额
     */
    @ApiField("amount")
    private BigDecimal amount;
    /**
     * 收款备注说明
     */
    @ApiField("remark")
    private String remark;
    /**
     * 支付渠道
     */
    @ApiField("payChannelList")
    private List<GetPayChannelBaseInfoRes> payChannelList;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public Long getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public String getFlowTitle() {
        return flowTitle;
    }

    public void setFlowTitle(String flowTitle) {
        this.flowTitle = flowTitle;
    }

    public Long getPsnId() {
        return psnId;
    }

    public void setPsnId(Long psnId) {
        this.psnId = psnId;
    }

    public String getPsnName() {
        return psnName;
    }

    public void setPsnName(String psnName) {
        this.psnName = psnName;
    }

    public Long getParticipantCorpId() {
        return participantCorpId;
    }

    public void setParticipantCorpId(Long participantCorpId) {
        this.participantCorpId = participantCorpId;
    }

    public String getParticipantCorpName() {
        return ParticipantCorpName;
    }

    public void setParticipantCorpName(String participantCorpName) {
        ParticipantCorpName = participantCorpName;
    }

    public String getPsnAccount() {
        return psnAccount;
    }

    public void setPsnAccount(String psnAccount) {
        this.psnAccount = psnAccount;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<GetPayChannelBaseInfoRes> getPayChannelList() {
        return payChannelList;
    }

    public void setPayChannelList(List<GetPayChannelBaseInfoRes> payChannelList) {
        this.payChannelList = payChannelList;
    }
}
