package com.yunyinsign.api.sdk.result.sign;


import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;




import java.util.List;

public class GetSignFlowSignerCoverRes extends BaseResponse {

    /**
     * 签署人信息ID
     */
    @ApiField("participantId")
    private Long participantId;
    /**
     * 参与方标识，例如甲方、乙方等容易理解的业务名词
     */
    @ApiField("participantFlag")
    private String participantFlag;
    /**
     * 当前签署状态:    1 - 填写中;  2 - 签署中; 3 - 已签署;  4 - 等待审批; 5 - 已拒签
     */
    @ApiField("signStatus")
    private Integer signStatus;
    /**
     * 企业id（个人类型时为空）
     */
    @ApiField("participantCorpId")
    private Long ParticipantCorpId;
    /**
     * 企业名称（个人类型时为空）
     */
    @ApiField("participantCorpName")
    private String ParticipantCorpName;
    /**
     * 参与方类型 1-企业 0-个人
     */
    @ApiField("participantType")
    private Integer participantType;
    /**
     * 参与方式：1-填写 2-签署；用英文逗号分隔
     */
    @ApiField("participateBizType")
    private List<String> participateBizType;
    /**
     * 企业经办人账号ID
     */
    @ApiField("psnId")
    private Long psnId;
    /**
     * 经办人名称
     */
    @ApiField("psnName")
    private String psnName;
    /**
     * 是否需要收款（0：否；1：是）
     */
    @ApiField("payeeContractFlag")
    private Integer payeeContractFlag;
    /**
     * 收款信息
     */
    @ApiField("payee")
    private GetSignFlowPayeeCoverRes payee;

    public Long getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public String getParticipantFlag() {
        return participantFlag;
    }

    public void setParticipantFlag(String participantFlag) {
        this.participantFlag = participantFlag;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public Long getParticipantCorpId() {
        return ParticipantCorpId;
    }

    public void setParticipantCorpId(Long participantCorpId) {
        ParticipantCorpId = participantCorpId;
    }

    public String getParticipantCorpName() {
        return ParticipantCorpName;
    }

    public void setParticipantCorpName(String participantCorpName) {
        ParticipantCorpName = participantCorpName;
    }

    public Integer getParticipantType() {
        return participantType;
    }

    public void setParticipantType(Integer participantType) {
        this.participantType = participantType;
    }

    public List<String> getParticipateBizType() {
        return participateBizType;
    }

    public void setParticipateBizType(List<String> participateBizType) {
        this.participateBizType = participateBizType;
    }

    public Long getPsnId() {
        return psnId;
    }

    public void setPsnId(Long psnId) {
        this.psnId = psnId;
    }

    public String getPsnName() {
        return psnName;
    }

    public void setPsnName(String psnName) {
        this.psnName = psnName;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public GetSignFlowPayeeCoverRes getPayee() {
        return payee;
    }

    public void setPayee(GetSignFlowPayeeCoverRes payee) {
        this.payee = payee;
    }
}
