package com.yunyinsign.api.sdk.result.sign;

import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;




import java.util.List;


public class GetSignFlowProcessRes  extends BaseResponse {

    /**
     * 流程ID
     */
    @ApiField("flowId")
    private Long flowId;
    /**
     * 流程状态: 0 - 草稿; 1 - 签署中; 2 - 完成; 3 - 撤销; 5 - 过期（签署截至日期到期后触发; 6 - 拒签
     */
    @ApiField("flowStatus")
    private Integer flowStatus;
    /**
     * 签署流程描述
     */
    @ApiField("flowDesc")
    private String flowDesc;
    /**
     * 流程标题
     */
    @ApiField("flowTitle")
    private String flowTitle;
    /**
     * 当前用户下步骤可以操作的状态:(0: 查看； 1： 填写；2：签署)
     */
    @ApiField("nextStatus")
    private Integer nextStatus;
    /**
     * 处理结果（批处理记录异常状态.）
     */
    //处理结果（批处理记录异常状态.）
    @ApiField("resultStatus")
    private String ResultStatus;
    /**
     * 处理结果（批处理记录异常信息.）
     */
    @ApiField("errorMessage")
    private String ErrorMessage;
    /**
     * 外部单号(企业app过来的可以保留一个外部来源单号)
     */
    @ApiField("sourceOrderCode")
    private String SourceOrderCode;
    /**
     * 签署方
     */
    @ApiField("participantList")
    private List<GetSignFlowSignerCoverRes> participantList;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public Integer getFlowStatus() {
        return flowStatus;
    }

    public void setFlowStatus(Integer flowStatus) {
        this.flowStatus = flowStatus;
    }

    public String getFlowDesc() {
        return flowDesc;
    }

    public void setFlowDesc(String flowDesc) {
        this.flowDesc = flowDesc;
    }

    public String getFlowTitle() {
        return flowTitle;
    }

    public void setFlowTitle(String flowTitle) {
        this.flowTitle = flowTitle;
    }

    public Integer getNextStatus() {
        return nextStatus;
    }

    public void setNextStatus(Integer nextStatus) {
        this.nextStatus = nextStatus;
    }

    public String getResultStatus() {
        return ResultStatus;
    }

    public void setResultStatus(String resultStatus) {
        ResultStatus = resultStatus;
    }

    public String getErrorMessage() {
        return ErrorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        ErrorMessage = errorMessage;
    }

    public String getSourceOrderCode() {
        return SourceOrderCode;
    }

    public void setSourceOrderCode(String sourceOrderCode) {
        SourceOrderCode = sourceOrderCode;
    }

    public List<GetSignFlowSignerCoverRes> getParticipantList() {
        return participantList;
    }

    public void setParticipantList(List<GetSignFlowSignerCoverRes> participantList) {
        this.participantList = participantList;
    }
}
