package com.yunyinsign.api.sdk.result.sign;


import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;




import java.math.BigDecimal;
import java.time.LocalDateTime;


public class GetSignFlowPayeeRes extends BaseResponse {
    /**
     * 收款信息ID
     */
    @ApiField("id")
    private Long id;
    /**
     * 合同ID
     */
    @ApiField("flowId")
    private Long flowId;
    /**
     * 参与方ID
     */
    @ApiField("signerId")
    private Long signerId;
    /**
     * 收款金额
     */
    @ApiField("amount")
    private BigDecimal amount;
    /**
     * 收款支付状态（0：未支付；1：已支付）
     */
    @ApiField("payeeStatus")
    private Integer payeeStatus;
    /**
     * 收款审批状态（0：未审批；1：已审批）
     */
    @ApiField("auditStatus")
    private Integer auditStatus;
    /**
     * 支付渠道类型(alipay：支付宝；wxpay：微信支付)
     */
    @ApiField("channelType")
    private String channelType;
    /**
     * 商户收款账户（对应支付宝账号或微信商户号）
     */
    @ApiField("merchantAccount")
    private String MerchantAccount;
    /**
     * 渠道商户订单号(支付宝支付号或微信支付单号)
     */
    @ApiField("merchantOrderNo")
    private String MerchantOrderNo;
    /**
     * 支付单id
     */
    @ApiField("payOrderId")
    private Long payOrderId;
    /**
     * 签署付款顺序(0：先付后签；1：先签后付)
     */
    @ApiField("priority")
    private Integer priority;
    /**
     * 收款备注说明
     */
    @ApiField("remark")
    private String remark;
    /**
     * 收款支付成功时间
     */
    @ApiField("payeeSuccessTime")
    private LocalDateTime payeeSuccessTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public Long getSignerId() {
        return signerId;
    }

    public void setSignerId(Long signerId) {
        this.signerId = signerId;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Integer getPayeeStatus() {
        return payeeStatus;
    }

    public void setPayeeStatus(Integer payeeStatus) {
        this.payeeStatus = payeeStatus;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getMerchantAccount() {
        return MerchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        MerchantAccount = merchantAccount;
    }

    public String getMerchantOrderNo() {
        return MerchantOrderNo;
    }

    public void setMerchantOrderNo(String merchantOrderNo) {
        MerchantOrderNo = merchantOrderNo;
    }

    public Long getPayOrderId() {
        return payOrderId;
    }

    public void setPayOrderId(Long payOrderId) {
        this.payOrderId = payOrderId;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public LocalDateTime getPayeeSuccessTime() {
        return payeeSuccessTime;
    }

    public void setPayeeSuccessTime(LocalDateTime payeeSuccessTime) {
        this.payeeSuccessTime = payeeSuccessTime;
    }
}
