package com.yunyinsign.api.sdk.result.sign;


import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;




import java.math.BigDecimal;


public class GetSignFlowPayeeCoverRes extends BaseResponse {

    /**
     * 收款信息ID
     */
    @ApiField("id")
    private Long id;
    /**
     * 收款金额
     */
    @ApiField("amount")
    private BigDecimal amount;
    /**
     * 收款支付状态（0：未支付；1：已支付）
     */
    @ApiField("payeeStatus")
    private Integer payeeStatus;
    /**
     * 收款审批状态（0：未审批；1：已审批）
     */
    @ApiField("auditStatus")
    private Integer auditStatus;
    /**
     * 签署付款顺序(0：先付后签；1：先签后付)
     */
    @ApiField("priority")
    private Integer priority;
    /**
     * 收款备注说明
     */
    @ApiField("remark")
    private String remark;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Integer getPayeeStatus() {
        return payeeStatus;
    }

    public void setPayeeStatus(Integer payeeStatus) {
        this.payeeStatus = payeeStatus;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
