package com.yunyinsign.api.sdk.result.sign;

import com.yunyinsign.api.sdk.core.BasePageResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;

import java.time.LocalDateTime;
import java.util.List;


/**
 * @author dyl
 */
public class GetSignFlowInfoRes extends BasePageResponse {

    /**
     * 签署流程ID
     */
    @ApiField("flowId")
    private Long flowId;
    /**
     * 公司名称
     */
    @ApiField("corpName")
    private String corpName;
    /**
     * 流程编码
     */
    @ApiField("flowCode")
    private String flowCode;
    /**
     * 签署流程标题
     */
    @ApiField("flowTitle")
    private String flowTitle;
    /**
     * 流程状态: 0 - 草稿; 1-填写 2 - 签署中; 3 - 完成; 4 - 撤销; 5 - 过期（签署截至日期到期后触发）; 6 - 拒签
     */
    @ApiField("flowStatus")
    private Integer flowStatus;
    /**
     * 签署流程描述
     */
    @ApiField("flowDesc")
    private String flowDesc;
    /**
     * 操作状态：(1 - 填写;  2 - 签署;  3 - 催办;  4 - 查看;)
     */
    @ApiField("operateStatus")
    private Integer operateStatus;
    /**
     * 发起方类型(0：个人；1：企业)
     */
    @ApiField("initiatorType")
    private Integer initiatorType;
    /**
     * 发起人ID
     */
    @ApiField("initiatorId")
    private Long initiatorId;
    /**
     * 发起人名称
     */
    @ApiField("initiatorName")
    private String initiatorName;
    /**
     * 是否直发类型(0：非直发；1：直接发起)
     */
    @ApiField("directFlag")
    private Integer directFlag;
    /**
     * 是否能分享(付款合同审核后才能分享；普通合同发起后就能分享)
     */
    @ApiField("shareFlag")
    private boolean shareFlag;
    /**
     * 是否加密合同(0: 普通合同；1：加密合同)
     */
    @ApiField("encryptFlag")
    private Integer encryptFlag;
    /**
     * 是否对方付（0：发起方付；1：对方付）
     */
    @ApiField("reversePayFlag")
    private Integer reversePayFlag;
    /**
     * 合同费用支付状态（0：未支付；1：已支付）
     */
    @ApiField("feePayFlag")
    private Integer feePayFlag;
    /**
     * 是否收款合同（0：否；1：收款合同）
     */
    @ApiField("payeeContractFlag")
    private Integer payeeContractFlag;
    /**
     * 签署流程开启时间
     */
    @ApiField("flowStartTime")
    private LocalDateTime flowStartTime;
    /**
     * 签署流程结束时间
     */
    @ApiField("flowFinishTime")
    private LocalDateTime flowFinishTime;
    /**
     * 外部单号(企业app过来的可以保留一个外部来源单号)
     */
    @ApiField("sourceOrderCode")
    private String SourceOrderCode;
    /**
     * 签署流程类型(0：正常签署流程；1：批次签署流程；2: 临时流程,对方通过小程序登录后可以更换手机号)
     */
    @ApiField("flowType")
    private Integer flowType;
    /**
     * 来源 (0: 云银签PC；1：云银签APP；10：外部系统PC；11：外部系统APP；12：外部系统H5；13：外部系统微信小程序；14：外部系统支付宝小程序；111：H5立即发起；112：H5模板发起；113：H5客户发起；121：微信小程序立即发起；122：微信小程序模板发起；123：微信小程序客户发起；)
     */
    @ApiField("source")
    private String source;
    /**
     * 流程创建时间
     */
    @ApiField("createTime")
    private LocalDateTime createTime;
    /**
     * 创建人
     */
    @ApiField("createBy")
    private String createBy;
    /**
     * 合同文件集合
     */
    @ApiField("contractFileList")
    private List<GetSignFlowContractFileRes> contractFileList;
    /**
     * 签署方集合
     */
    @ApiField("participantList")
    private List<GetSignFlowSignerRes> participantList;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public String getFlowCode() {
        return flowCode;
    }

    public void setFlowCode(String flowCode) {
        this.flowCode = flowCode;
    }

    public String getFlowTitle() {
        return flowTitle;
    }

    public void setFlowTitle(String flowTitle) {
        this.flowTitle = flowTitle;
    }

    public Integer getFlowStatus() {
        return flowStatus;
    }

    public void setFlowStatus(Integer flowStatus) {
        this.flowStatus = flowStatus;
    }

    public String getFlowDesc() {
        return flowDesc;
    }

    public void setFlowDesc(String flowDesc) {
        this.flowDesc = flowDesc;
    }

    public Integer getOperateStatus() {
        return operateStatus;
    }

    public void setOperateStatus(Integer operateStatus) {
        this.operateStatus = operateStatus;
    }

    public Integer getInitiatorType() {
        return initiatorType;
    }

    public void setInitiatorType(Integer initiatorType) {
        this.initiatorType = initiatorType;
    }

    public Long getInitiatorId() {
        return initiatorId;
    }

    public void setInitiatorId(Long initiatorId) {
        this.initiatorId = initiatorId;
    }

    public String getInitiatorName() {
        return initiatorName;
    }

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public Integer getDirectFlag() {
        return directFlag;
    }

    public void setDirectFlag(Integer directFlag) {
        this.directFlag = directFlag;
    }

    public boolean isShareFlag() {
        return shareFlag;
    }

    public void setShareFlag(boolean shareFlag) {
        this.shareFlag = shareFlag;
    }

    public Integer getEncryptFlag() {
        return encryptFlag;
    }

    public void setEncryptFlag(Integer encryptFlag) {
        this.encryptFlag = encryptFlag;
    }

    public Integer getReversePayFlag() {
        return reversePayFlag;
    }

    public void setReversePayFlag(Integer reversePayFlag) {
        this.reversePayFlag = reversePayFlag;
    }

    public Integer getFeePayFlag() {
        return feePayFlag;
    }

    public void setFeePayFlag(Integer feePayFlag) {
        this.feePayFlag = feePayFlag;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public LocalDateTime getFlowStartTime() {
        return flowStartTime;
    }

    public void setFlowStartTime(LocalDateTime flowStartTime) {
        this.flowStartTime = flowStartTime;
    }

    public LocalDateTime getFlowFinishTime() {
        return flowFinishTime;
    }

    public void setFlowFinishTime(LocalDateTime flowFinishTime) {
        this.flowFinishTime = flowFinishTime;
    }

    public String getSourceOrderCode() {
        return SourceOrderCode;
    }

    public void setSourceOrderCode(String sourceOrderCode) {
        SourceOrderCode = sourceOrderCode;
    }

    public Integer getFlowType() {
        return flowType;
    }

    public void setFlowType(Integer flowType) {
        this.flowType = flowType;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public List<GetSignFlowContractFileRes> getContractFileList() {
        return contractFileList;
    }

    public void setContractFileList(List<GetSignFlowContractFileRes> contractFileList) {
        this.contractFileList = contractFileList;
    }

    public List<GetSignFlowSignerRes> getParticipantList() {
        return participantList;
    }

    public void setParticipantList(List<GetSignFlowSignerRes> participantList) {
        this.participantList = participantList;
    }
}
