package com.yunyinsign.api.sdk.result.sign;


import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;




import java.util.List;

public class GetSignFlowCoverInoRes extends BaseResponse {

    /**
     * 流程ID
     */
    @ApiField("flowId" )
    private Long flowId;
    /**
     * 企业类型时企业ID
     */
    @ApiField("corpId")
    private Long corpId;
    /**
     * 公司名称
     */
    @ApiField("corpName")
    private String corpName;
    /**
     * 签署流程标题
     */
    @ApiField("flowTitle")
    private String flowTitle;
    /**
     * 流程状态: 0 - 草稿; 1-填写 2 - 签署中; 3 - 完成; 4 - 撤销; 5 - 过期（签署截至日期到期后触发）; 6 - 拒签
     */
    @ApiField("flowStatus")
    private Integer flowStatus;
    /**
     * 签署流程描述
     */
    @ApiField("flowDesc")
    private String flowDesc;
    /**
     * 操作状态：(1 - 填写;  2 - 签署;  3 - 催办;  4 - 查看;)
     */
    @ApiField("operateStatus")
    private Integer operateStatus;
    /**
     * 发起方类型(0：个人；1：企业)
     */
    @ApiField("initiatorType")
    private Integer initiatorType;
    /**
     * 发起人ID
     */
    @ApiField("initiatorId")
    private Long initiatorId;
    /**
     * 发起人名称
     */
    @ApiField("initiatorName")
    private String initiatorName;
    /**
     * 是否直发类型(0：非直发；1：直接发起)
     */
    @ApiField("directFlag")
    private Integer directFlag;
    /**
     * 是否加密合同(0: 普通合同；1：加密合同)
     */
    @ApiField("encryptFlag")
    private Integer encryptFlag;
    /**
     * 是否对方付（0：发起方付；1：对方付）
     */
    @ApiField("reversePayFlag")
    private Integer reversePayFlag;
    /**
     * 合同费用支付状态（0：未支付；1：已支付）
     */
    @ApiField("feePayFlag")
    private Integer feePayFlag;
    /**
     * 是否收款合同（0：否；1：收款合同）
     */
    @ApiField("payeeContractFlag")
    private Integer payeeContractFlag;
    /**
     * 当前用户ID
     */
    @ApiField("currentUserMobile")
    private String currentUserMobile;
    /**
     * 个人实名： 1: 实名；0: 未实名
     */
    @ApiField("memberIdent")
    private Integer memberIdent;
    /**
     * 企业实名： 1: 实名；0: 未实名
     */
    @ApiField("corpIdent")
    private Integer corpIdent;
    /**
     * 可用账号余额
     */
    @ApiField("accountBalance")
    private Integer accountBalance;
    /**
     * 参与者列表
     */
    @ApiField("signerList")
    private List<GetSignFlowSignerCoverRes> signerList;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public String getFlowTitle() {
        return flowTitle;
    }

    public void setFlowTitle(String flowTitle) {
        this.flowTitle = flowTitle;
    }

    public Integer getFlowStatus() {
        return flowStatus;
    }

    public void setFlowStatus(Integer flowStatus) {
        this.flowStatus = flowStatus;
    }

    public String getFlowDesc() {
        return flowDesc;
    }

    public void setFlowDesc(String flowDesc) {
        this.flowDesc = flowDesc;
    }

    public Integer getOperateStatus() {
        return operateStatus;
    }

    public void setOperateStatus(Integer operateStatus) {
        this.operateStatus = operateStatus;
    }

    public Integer getInitiatorType() {
        return initiatorType;
    }

    public void setInitiatorType(Integer initiatorType) {
        this.initiatorType = initiatorType;
    }

    public Long getInitiatorId() {
        return initiatorId;
    }

    public void setInitiatorId(Long initiatorId) {
        this.initiatorId = initiatorId;
    }

    public String getInitiatorName() {
        return initiatorName;
    }

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public Integer getDirectFlag() {
        return directFlag;
    }

    public void setDirectFlag(Integer directFlag) {
        this.directFlag = directFlag;
    }

    public Integer getEncryptFlag() {
        return encryptFlag;
    }

    public void setEncryptFlag(Integer encryptFlag) {
        this.encryptFlag = encryptFlag;
    }

    public Integer getReversePayFlag() {
        return reversePayFlag;
    }

    public void setReversePayFlag(Integer reversePayFlag) {
        this.reversePayFlag = reversePayFlag;
    }

    public Integer getFeePayFlag() {
        return feePayFlag;
    }

    public void setFeePayFlag(Integer feePayFlag) {
        this.feePayFlag = feePayFlag;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public String getCurrentUserMobile() {
        return currentUserMobile;
    }

    public void setCurrentUserMobile(String currentUserMobile) {
        this.currentUserMobile = currentUserMobile;
    }

    public Integer getMemberIdent() {
        return memberIdent;
    }

    public void setMemberIdent(Integer memberIdent) {
        this.memberIdent = memberIdent;
    }

    public Integer getCorpIdent() {
        return corpIdent;
    }

    public void setCorpIdent(Integer corpIdent) {
        this.corpIdent = corpIdent;
    }

    public Integer getAccountBalance() {
        return accountBalance;
    }

    public void setAccountBalance(Integer accountBalance) {
        this.accountBalance = accountBalance;
    }

    public List<GetSignFlowSignerCoverRes> getSignerList() {
        return signerList;
    }

    public void setSignerList(List<GetSignFlowSignerCoverRes> signerList) {
        this.signerList = signerList;
    }
}
