package com.yunyinsign.api.sdk.result.sign;

import com.yunyinsign.api.sdk.core.BasePageResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;
import com.yunyinsign.api.sdk.result.GetTemplateCopierRes;


import java.time.LocalDateTime;
import java.util.List;


/**
 * @author dyl
 */
public class GetSignFlowCorpInfoRes  extends BasePageResponse {

    /**
     * 流程ID
     */
    @ApiField("flowId")
    private Long flowId;
    /**
     * 流程编码
     */
    @ApiField("flowCode")
    private String flowCode;
    /**
     * 签署流程标题
     */
    @ApiField("flowTitle")
    private String flowTitle;
    /**
     * 当前流程状态: 0 - 草稿; 1 - 签署中; 2 - 完成; 3 - 撤销; 5 - 过期（签署截至日期到期后触发; 6 - 拒签
     */
    @ApiField("flowStatus")
    private Integer flowStatus;
    /**
     * 签署流程描述: 如果流程已拒签或已撤销，并且存在拒签或撤回原因，流程描述显示为原因,，否则默认为流程状态描述
     */
    @ApiField("flowDesc")
    private String flowDesc;
    /**
     * 签署流程开启时间
     */
    @ApiField("flowStartTime")
    private LocalDateTime flowStartTime;
    /**
     * 签署流程结束时间
     */
    @ApiField("flowFinishTime")
    private LocalDateTime flowFinishTime;
    /**
     * 截止时间
     */
    @ApiField("expireDate")
    private LocalDateTime expireDate;
    /**
     * 模板ID
     */
    @ApiField("templateId")
    private Long templateId;
    /**
     * 模板名称
     */
    @ApiField("templateName")
    private String templateName;
    /**
     * 发起人ID或企业经办人ID
     */
    @ApiField("initiatorId")
    private Long initiatorId;
    /**
     * 发起人名称
     */
    @ApiField("initiatorName")
    private String initiatorName;
    /**
     * 发起方类型(0：个人；1：企业)
     */
    @ApiField("initiatorType")
    private Integer initiatorType;
    /**
     * 企业类型时企业ID
     */
    @ApiField("corpId")
    private Long corpId;
    /**
     * 企业类型时企业名称
     */
    @ApiField("corpName")
    private String corpName;
    /**
     * 当前用户可对当前合同操作的状态(1 - 填写;  2 - 签署;  3 - 催办;  4 - 查看;)
     */
    @ApiField("operateStatus")
    private Integer operateStatus;
    /**
     * 是否保密（0： 不保密；1：保密）
     */
    @ApiField("privacyType")
    private Long privacyType;
    /**
     * 是否加密合同(0: 普通合同；1：加密合同)
     */
    @ApiField("encryptFlag")
    private Integer encryptFlag;
    /**
     * 是否对方付（0：发起方付；1：对方付）
     */
    @ApiField("reversePayFlag")
    private Integer reversePayFlag;
    /**
     * 合同费用支付状态（0：未支付；1：已支付）
     */
    @ApiField("feePayFlag")
    private Integer feePayFlag;
    /**
     * 是否收款合同（0：否；1：收款合同）
     */
    @ApiField("payeeContractFlag")
    private Integer payeeContractFlag;
    /**
     * 外部单号(企业app过来的可以保留一个外部来源单号)
     */
    @ApiField("sourceOrderCode")
    private String SourceOrderCode;
    /**
     * 来源 (0: 云银签PC；1：云银签APP；10：外部系统PC；11：外部系统APP；12：外部系统H5；13：外部系统微信小程序；14：外部系统支付宝小程序；111：H5立即发起；112：H5模板发起；113：H5客户发起；121：微信小程序立即发起；122：微信小程序模板发起；123：微信小程序客户发起；)
     */
    @ApiField("source")
    private String source;
    /**
     * 备注
     */
    @ApiField("remark")
    private String remark;
    /**
     * 签署文件
     */
    @ApiField("signFlowContractFileRespList")
    private List<GetSignFlowContractFileRes> signFlowContractFileRespList;
    /**
     * 签署方
     */
    @ApiField("signFlowSignerResps")
    private List<GetSignFlowSignerRes> signFlowSignerResps;
    /**
     * 附属文件
     */
    @ApiField("signFlowAttachmentRespList")
    private List<GetSignFlowAttachmentRes> signFlowAttachmentRespList;
    /**
     * 抄送方
     */
    @ApiField("templateCopierResp")
    private List<GetTemplateCopierRes> templateCopierResp;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public String getFlowCode() {
        return flowCode;
    }

    public void setFlowCode(String flowCode) {
        this.flowCode = flowCode;
    }

    public String getFlowTitle() {
        return flowTitle;
    }

    public void setFlowTitle(String flowTitle) {
        this.flowTitle = flowTitle;
    }

    public Integer getFlowStatus() {
        return flowStatus;
    }

    public void setFlowStatus(Integer flowStatus) {
        this.flowStatus = flowStatus;
    }

    public String getFlowDesc() {
        return flowDesc;
    }

    public void setFlowDesc(String flowDesc) {
        this.flowDesc = flowDesc;
    }

    public LocalDateTime getFlowStartTime() {
        return flowStartTime;
    }

    public void setFlowStartTime(LocalDateTime flowStartTime) {
        this.flowStartTime = flowStartTime;
    }

    public LocalDateTime getFlowFinishTime() {
        return flowFinishTime;
    }

    public void setFlowFinishTime(LocalDateTime flowFinishTime) {
        this.flowFinishTime = flowFinishTime;
    }

    public LocalDateTime getExpireDate() {
        return expireDate;
    }

    public void setExpireDate(LocalDateTime expireDate) {
        this.expireDate = expireDate;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Long getInitiatorId() {
        return initiatorId;
    }

    public void setInitiatorId(Long initiatorId) {
        this.initiatorId = initiatorId;
    }

    public String getInitiatorName() {
        return initiatorName;
    }

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public Integer getInitiatorType() {
        return initiatorType;
    }

    public void setInitiatorType(Integer initiatorType) {
        this.initiatorType = initiatorType;
    }

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public Integer getOperateStatus() {
        return operateStatus;
    }

    public void setOperateStatus(Integer operateStatus) {
        this.operateStatus = operateStatus;
    }

    public Long getPrivacyType() {
        return privacyType;
    }

    public void setPrivacyType(Long privacyType) {
        this.privacyType = privacyType;
    }

    public Integer getEncryptFlag() {
        return encryptFlag;
    }

    public void setEncryptFlag(Integer encryptFlag) {
        this.encryptFlag = encryptFlag;
    }

    public Integer getReversePayFlag() {
        return reversePayFlag;
    }

    public void setReversePayFlag(Integer reversePayFlag) {
        this.reversePayFlag = reversePayFlag;
    }

    public Integer getFeePayFlag() {
        return feePayFlag;
    }

    public void setFeePayFlag(Integer feePayFlag) {
        this.feePayFlag = feePayFlag;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public String getSourceOrderCode() {
        return SourceOrderCode;
    }

    public void setSourceOrderCode(String sourceOrderCode) {
        SourceOrderCode = sourceOrderCode;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<GetSignFlowContractFileRes> getSignFlowContractFileRespList() {
        return signFlowContractFileRespList;
    }

    public void setSignFlowContractFileRespList(List<GetSignFlowContractFileRes> signFlowContractFileRespList) {
        this.signFlowContractFileRespList = signFlowContractFileRespList;
    }

    public List<GetSignFlowSignerRes> getSignFlowSignerResps() {
        return signFlowSignerResps;
    }

    public void setSignFlowSignerResps(List<GetSignFlowSignerRes> signFlowSignerResps) {
        this.signFlowSignerResps = signFlowSignerResps;
    }

    public List<GetSignFlowAttachmentRes> getSignFlowAttachmentRespList() {
        return signFlowAttachmentRespList;
    }

    public void setSignFlowAttachmentRespList(List<GetSignFlowAttachmentRes> signFlowAttachmentRespList) {
        this.signFlowAttachmentRespList = signFlowAttachmentRespList;
    }

    public List<GetTemplateCopierRes> getTemplateCopierResp() {
        return templateCopierResp;
    }

    public void setTemplateCopierResp(List<GetTemplateCopierRes> templateCopierResp) {
        this.templateCopierResp = templateCopierResp;
    }
}
