package com.yunyinsign.api.sdk.result.sign;

import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;

import java.math.BigDecimal;
import java.util.Map;

public class GetSignComponentRes extends BaseResponse {

    /**
     * 组件信息ID
     */
    @ApiField("componentId")
    private Long componentId;
    /**
     * 流程ID
     */
    @ApiField("flowId")
    private Long flowId;
    /**
     * 参与方类型 1-企业 0-个人
     */
    @ApiField("participantType")
    private Integer participantType;
    /**
     * 参与方ID
     */
    @ApiField("participantId")
    private Long participantId;
    /**
     * 参与方企业名称
     */
    @ApiField("participantCorpName")
    private String participantCorpName;
    /**
     * 经办人名称
     */
    @ApiField("psnName")
    private String psnName;
    /**
     * 合同文档ID
     */
    @ApiField("contractFileId")
    private Long contractFileId;
    /**
     * 控件Key
     */
    @ApiField("componentKey")
    private String componentKey;
    /**
     * 控件名称
     */
    @ApiField("componentName")
    private String componentName;
    /**
     * 控件类型：1 - 单行文本，2 - 数字，3 - 日期，6 - 签章区域，8 - 多行文本，9 - 复选，10 - 单选，11 - 图片，14 -下拉框，15 - 勾选框，16 - 身份证，17 - 备注区域，18 - 动态表格，19 - 手机号
     */
    @ApiField("componentType")
    private Integer componentType;
    /**
     * 控件值
     */
    @ApiField("value")
    private String value;
    /**
     * 控件默认值
     */
    @ApiField("defaultValue")
    private String defaultValue;
    /**
     * 控件是否必填：1 - 必填；0- 非必填
     */
    @ApiField("required")
    private Integer required;
    /**
     * X横坐标
     */
    @ApiField("PositionX")
    private BigDecimal positionX;
    /**
     * Y纵坐标值
     */
    @ApiField("PositionY")
    private BigDecimal positionY;
    /**
     * 页码
     */
    @ApiField("pageNum")
    private Integer pageNum;
    /**
     * 控件宽度
     */
    @ApiField("width")
    private Integer width;
    /**
     * 控件高度
     */
    @ApiField("height")
    private Integer height;
    /**
     * 控件特有属性
     */
    @ApiField("specialAttribute")
    private Map<String, Object> specialAttribute;
    /**
     * 来源自定义控件id
     */
    @ApiField("customComponentId")
    private Long customComponentId;

    public Long getComponentId() {
        return componentId;
    }

    public void setComponentId(Long componentId) {
        this.componentId = componentId;
    }

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public Integer getParticipantType() {
        return participantType;
    }

    public void setParticipantType(Integer participantType) {
        this.participantType = participantType;
    }

    public Long getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public String getParticipantCorpName() {
        return participantCorpName;
    }

    public void setParticipantCorpName(String participantCorpName) {
        this.participantCorpName = participantCorpName;
    }

    public String getPsnName() {
        return psnName;
    }

    public void setPsnName(String psnName) {
        this.psnName = psnName;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public String getComponentKey() {
        return componentKey;
    }

    public void setComponentKey(String componentKey) {
        this.componentKey = componentKey;
    }

    public String getComponentName() {
        return componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public Integer getComponentType() {
        return componentType;
    }

    public void setComponentType(Integer componentType) {
        this.componentType = componentType;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Integer getRequired() {
        return required;
    }

    public void setRequired(Integer required) {
        this.required = required;
    }

    public BigDecimal getPositionX() {
        return positionX;
    }

    public void setPositionX(BigDecimal positionX) {
        this.positionX = positionX;
    }

    public BigDecimal getPositionY() {
        return positionY;
    }

    public void setPositionY(BigDecimal positionY) {
        this.positionY = positionY;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Map<String, Object> getSpecialAttribute() {
        return specialAttribute;
    }

    public void setSpecialAttribute(Map<String, Object> specialAttribute) {
        this.specialAttribute = specialAttribute;
    }

    public Long getCustomComponentId() {
        return customComponentId;
    }

    public void setCustomComponentId(Long customComponentId) {
        this.customComponentId = customComponentId;
    }
}
