package com.yunyinsign.api.sdk.result.sign;

import com.yunyinsign.api.sdk.core.BasePageResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 审批管理，响应vo
 * @author 荣超
 */
public class ApprovalInfoRes  extends BasePageResponse {

    /**
     * 审批申请ID
     */
    @ApiField("approvalId")
    private Long approvalId;
    /**
     * 企业名称
     */
    @ApiField("corpName")
    private String corpName;
    /**
     * 审批编码
     */
    @ApiField("approvalCode")
    private String approvalCode;
    /**
     * 审批名称
     */
    @ApiField("approvalName")
    private String approvalName;
    /**
     * 合同ID
     */
    @ApiField("signFlowId")
    private Long signFlowId;
    /**
     * 合同名称
     */
    @ApiField("signFlowName")
    private String signFlowName;
    /**
     * 审核类型(1: 合同用章审批),2 合同审批
     */
    @ApiField("approvalType")
    private Integer approvalType;
    /**
     * 审批状态（1-审批中；2-审批通过；3-审批驳回；4-审批撤回；5-审批终止（超时未审批））
     */
    @ApiField("approvalStatus")
    private Integer approvalStatus;
    /**
     * 印章ID
     */
    @ApiField("sealId")
    private Long sealId;
    /**
     * 印章名称
     */
    @ApiField("sealName")
    private String sealName;
    /**
     * 发起人ID
     */
    @ApiField("initiatorId")
    private Long initiatorId;
    /**
     * 发起人名称
     */
    @ApiField("initiatorName")
    private String initiatorName;
    /**
     * 合同发起时间
     */
    @ApiField("flowCreateTime")
    private LocalDateTime flowCreateTime;
    /**
     * 是否加密合同(0: 普通合同；1：加密合同)
     */
    @ApiField("encryptFlag")
    private Integer encryptFlag;
    /**
     * 是否对方付（0：发起方付；1：对方付）
     */
    @ApiField("reversePayFlag")
    private Integer reversePayFlag;
    /**
     * 合同费用支付状态（0：未支付；1：已支付）
     */
    @ApiField("feePayFlag")
    private Integer feePayFlag;
    /**
     * 是否收款合同（0：否；1：收款合同）
     */
    @ApiField("payeeContractFlag")
    private Integer payeeContractFlag;
    /**
     * 创建时间
     */
    @ApiField("createTime")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @ApiField("updateTime")
    private LocalDateTime updateTime;
    /**
     * 签署方集合
     */
    @ApiField("signerList")
    private List<GetSignFlowSignerRes> signerList;

    public Long getApprovalId() {
        return approvalId;
    }

    public void setApprovalId(Long approvalId) {
        this.approvalId = approvalId;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public String getApprovalCode() {
        return approvalCode;
    }

    public void setApprovalCode(String approvalCode) {
        this.approvalCode = approvalCode;
    }

    public String getApprovalName() {
        return approvalName;
    }

    public void setApprovalName(String approvalName) {
        this.approvalName = approvalName;
    }

    public Long getSignFlowId() {
        return signFlowId;
    }

    public void setSignFlowId(Long signFlowId) {
        this.signFlowId = signFlowId;
    }

    public String getSignFlowName() {
        return signFlowName;
    }

    public void setSignFlowName(String signFlowName) {
        this.signFlowName = signFlowName;
    }

    public Integer getApprovalType() {
        return approvalType;
    }

    public void setApprovalType(Integer approvalType) {
        this.approvalType = approvalType;
    }

    public Integer getApprovalStatus() {
        return approvalStatus;
    }

    public void setApprovalStatus(Integer approvalStatus) {
        this.approvalStatus = approvalStatus;
    }

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public String getSealName() {
        return sealName;
    }

    public void setSealName(String sealName) {
        this.sealName = sealName;
    }

    public Long getInitiatorId() {
        return initiatorId;
    }

    public void setInitiatorId(Long initiatorId) {
        this.initiatorId = initiatorId;
    }

    public String getInitiatorName() {
        return initiatorName;
    }

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public LocalDateTime getFlowCreateTime() {
        return flowCreateTime;
    }

    public void setFlowCreateTime(LocalDateTime flowCreateTime) {
        this.flowCreateTime = flowCreateTime;
    }

    public Integer getEncryptFlag() {
        return encryptFlag;
    }

    public void setEncryptFlag(Integer encryptFlag) {
        this.encryptFlag = encryptFlag;
    }

    public Integer getReversePayFlag() {
        return reversePayFlag;
    }

    public void setReversePayFlag(Integer reversePayFlag) {
        this.reversePayFlag = reversePayFlag;
    }

    public Integer getFeePayFlag() {
        return feePayFlag;
    }

    public void setFeePayFlag(Integer feePayFlag) {
        this.feePayFlag = feePayFlag;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public List<GetSignFlowSignerRes> getSignerList() {
        return signerList;
    }

    public void setSignerList(List<GetSignFlowSignerRes> signerList) {
        this.signerList = signerList;
    }
}
