package com.yunyinsign.api.sdk.result.seal;

import com.yunyinsign.api.sdk.core.BasePageResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;

import java.time.LocalDateTime;


/**
 * @author dyl
 */
public class GetSealInfoRes extends BasePageResponse {

    /**
     * 印章ID
     */
    @ApiField("sealId")
    private Long sealId;
    /**
     * 企业名称
     */
    @ApiField("corpName")
    private String corpName;
    /**
     * 印章编号
     */
    @ApiField("sealCode")
    private String sealCode;
    /**
     * 印章名称
     */
    @ApiField("sealName")
    private String sealName;
    /**
     * 印章类型：PUBLIC - 公章; CONTRACT - 合同专用章; FINANCE - 财务专用章; HR - 人事专用章; LEGAL_PERSON - 法定代表人章; OTHER - 其他
     */
    @ApiField("categoryType")
    private String categoryType;
    /**
     * 印章制作方式: 1 - 机构模板章，3 - 图片印章（上传本地文件）
     */
    @ApiField("sealStyle")
    private Integer sealStyle;
    /**
     * 印章宽
     */
    @ApiField("sealWidth")
    private Integer sealWidth;
    /**
     * 印章高
     */
    @ApiField("sealHeight")
    private Integer sealHeight;
    /**
     * 印章图片
     */
    @ApiField("sealImageUrl")
    private String sealImageUrl;
    /**
     * 是否默认章(0：不是；1：是)
     */
    @ApiField("defaultFlag")
    private Integer defaultFlag;
    /**
     * 印章状态:  1 - 已启用，2 - 待审核， 3 - 审核不通过，4 - 挂起
     */
    @ApiField("sealStatus")
    private Integer sealStatus;
    /**
     * 横向文
     */
    @ApiField("sealHorizontalText")
    private String sealHorizontalText;
    /**
     * 下弦文（实体印章防伪码)
     */
    @ApiField("sealBottomText")
    private String sealBottomText;
    /**
     * 印章来源
     */
    @ApiField("source")
    private String source;
    /**
     * 授权数量
     */
    @ApiField("authorNum")
    private Integer authorNum;
    /**
     * 创建时间
     */
    @ApiField("createTime")
    private LocalDateTime createTime;

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public String getSealCode() {
        return sealCode;
    }

    public void setSealCode(String sealCode) {
        this.sealCode = sealCode;
    }

    public String getSealName() {
        return sealName;
    }

    public void setSealName(String sealName) {
        this.sealName = sealName;
    }

    public String getCategoryType() {
        return categoryType;
    }

    public void setCategoryType(String categoryType) {
        this.categoryType = categoryType;
    }

    public Integer getSealStyle() {
        return sealStyle;
    }

    public void setSealStyle(Integer sealStyle) {
        this.sealStyle = sealStyle;
    }

    public Integer getSealWidth() {
        return sealWidth;
    }

    public void setSealWidth(Integer sealWidth) {
        this.sealWidth = sealWidth;
    }

    public Integer getSealHeight() {
        return sealHeight;
    }

    public void setSealHeight(Integer sealHeight) {
        this.sealHeight = sealHeight;
    }

    public String getSealImageUrl() {
        return sealImageUrl;
    }

    public void setSealImageUrl(String sealImageUrl) {
        this.sealImageUrl = sealImageUrl;
    }

    public Integer getDefaultFlag() {
        return defaultFlag;
    }

    public void setDefaultFlag(Integer defaultFlag) {
        this.defaultFlag = defaultFlag;
    }

    public Integer getSealStatus() {
        return sealStatus;
    }

    public void setSealStatus(Integer sealStatus) {
        this.sealStatus = sealStatus;
    }

    public String getSealHorizontalText() {
        return sealHorizontalText;
    }

    public void setSealHorizontalText(String sealHorizontalText) {
        this.sealHorizontalText = sealHorizontalText;
    }

    public String getSealBottomText() {
        return sealBottomText;
    }

    public void setSealBottomText(String sealBottomText) {
        this.sealBottomText = sealBottomText;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Integer getAuthorNum() {
        return authorNum;
    }

    public void setAuthorNum(Integer authorNum) {
        this.authorNum = authorNum;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
}
