package com.yunyinsign.api.sdk.result.seal;

import com.yunyinsign.api.sdk.core.BasePageResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;

import java.time.LocalDateTime;


/**
 * @author dyl
 */
public class GetSealAuthorInfoRes extends BasePageResponse {

    /**
     * 授权记录id
     */
    @ApiField("id")
    private Long id;
    /**
     * 印章ID
     */
    @ApiField("sealId")
    private Long sealId;
    /**
     * 用户ID
     */
    @ApiField("userId")
    private Long userId;
    /**
     * 用户名称
     */
    @ApiField("userName")
    private String userName;
    /**
     * 授权角色：SEAL_USER - 印章使用员（印章使用权限）；SEAL_EXAMINER - 印章审批员（印章使用权限+用印审批权限）
     */
    @ApiField("authorRole")
    private String authorRole;
    /**
     * 授权范围(0：全部合同；1：指定模板)
     */
    @ApiField("authorRange")
    private Integer authorRange;
    /**
     * 印章是否设置自动落章，默认值 0：false；1 - 设置自动落章。【注】（1）设置自动落章必须授权全部企业成员，并且指定具体的模板编号。 （2）设置自动落章后，使用对应的模板发起签署的文件无需经办人手动签署，可自动加盖。（3）同一个模板只能授权对应企业下某一个印章自动落章，不允许多个印章自动落章。
     */
    @ApiField("autoSign")
    private Integer autoSign;
    /**
     * 授权生效时间
     */
    @ApiField("effectiveTime")
    private LocalDateTime effectiveTime;
    /**
     * 授权失效时间
     */
    @ApiField("expireTime")
    private LocalDateTime expireTime;
    /**
     * 印章审批员是否接受审批通知(0: 不接受；1： 接受)
     */
    @ApiField("examinerNotify")
    private Integer examinerNotify;
    /**
     * 状态
     */
    @ApiField("status")
    private Integer status;
    /**
     * 指定模板时指定的模板（最大10个模板）
     */
    @ApiField("templates")
    private String templates;
    /**
     * 模板名称（最大10个模板）
     */
    @ApiField("templateName")
    private String templateName;
    /**
     * 创建时间
     */
    @ApiField("createTime")
    private LocalDateTime createTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAuthorRole() {
        return authorRole;
    }

    public void setAuthorRole(String authorRole) {
        this.authorRole = authorRole;
    }

    public Integer getAuthorRange() {
        return authorRange;
    }

    public void setAuthorRange(Integer authorRange) {
        this.authorRange = authorRange;
    }

    public Integer getAutoSign() {
        return autoSign;
    }

    public void setAutoSign(Integer autoSign) {
        this.autoSign = autoSign;
    }

    public LocalDateTime getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(LocalDateTime effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public LocalDateTime getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(LocalDateTime expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getExaminerNotify() {
        return examinerNotify;
    }

    public void setExaminerNotify(Integer examinerNotify) {
        this.examinerNotify = examinerNotify;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getTemplates() {
        return templates;
    }

    public void setTemplates(String templates) {
        this.templates = templates;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
}
