package com.yunyinsign.api.sdk.result.pay;


import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;

import java.math.BigDecimal;


public class GetPayUrlInfoRes extends BaseResponse {

    /**
     * 支付单id
     */
    @ApiField("id")
    private Long id;
    /**
     * 支付单编码
     */
    @ApiField("orderCode")
    private String orderCode;
    /**
     * 支付类型(wxJSAPI-微信JSAPI支付,wxH5-微信H5支付,wxQrCode-微信二维码支付,alipayJSAPI-支付宝JSAPI支付,alipayPC-支付宝网站,alipayMobile-支付宝手机端,alipayPre-支付宝当面付)
     */
    @ApiField("payTypeCode")
    private String payTypeCode;
    /**
     * 商户收款账户
     */
    @ApiField("merchantAccount")
    private String merchantAccount;
    /**
     * 商户类型(0：服务商；1：二级商户；2：普通商户)
     */
    @ApiField("merchantType")
    private Integer merchantType;
    /**
     * 业务单号
     */
    @ApiField("businessOrderNo")
    private String businessOrderNo;
    /**
     * 支付状态: 0-订单生成, 1-支付中, 2-支付成功, 3-支付失败, 4-已退款
     */
    @ApiField("status")
    private Integer status;
    /**
     * 支付商品类型(0: 购买套餐；1：单合同签；2：支付收款合同款项；3：出证套餐)
     */
    @ApiField("goodsType")
    private Integer goodsType;
    /**
     * 商品名称
     */
    @ApiField("goodsName")
    private String goodsName;
    /**
     * 支付金额
     */
    @ApiField("amount")
    private BigDecimal amount;
    /**
     * 支付链接
     */
    @ApiField("payUrl")
    private String payUrl;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getPayTypeCode() {
        return payTypeCode;
    }

    public void setPayTypeCode(String payTypeCode) {
        this.payTypeCode = payTypeCode;
    }

    public String getMerchantAccount() {
        return merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public Integer getMerchantType() {
        return merchantType;
    }

    public void setMerchantType(Integer merchantType) {
        this.merchantType = merchantType;
    }

    public String getBusinessOrderNo() {
        return businessOrderNo;
    }

    public void setBusinessOrderNo(String businessOrderNo) {
        this.businessOrderNo = businessOrderNo;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(Integer goodsType) {
        this.goodsType = goodsType;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getPayUrl() {
        return payUrl;
    }

    public void setPayUrl(String payUrl) {
        this.payUrl = payUrl;
    }
}
