package com.yunyinsign.api.sdk.result.pay;


import com.yunyinsign.api.sdk.core.BasePageResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;

import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * @author dyl
 */
public class GetPayOrderRes extends BasePageResponse {

    /**
     * 支付单id
     */
    @ApiField("id")
    private Long id;
    /**
     * 订单类型(0：个人；1：企业)
     */
    @ApiField("orderType")
    private Integer orderType;
    /**
     * 支付单编码
     */
    @ApiField("orderCode")
    private String orderCode;
    /**
     * 企业ID
     */
    @ApiField("corpId")
    private Long corpId;
    /**
     * 企业名称
     */
    @ApiField("corpName")
    private String corpName;
    /**
     * 个人或企业经办人ID
     */
    @ApiField("psnId")
    private Long psnId;
    /**
     * 支付人
     */
    @ApiField("psnName")
    private String psnName;
    /**
     * 通道方式ID
     */
    @ApiField("channelModelId")
    private Long channelModelId;
    /**
     * 支付提供商(alipay-支付宝支付,wxpay-微信支付)
     */
    @ApiField("providerCode")
    private String providerCode;
    /**
     * 支付类型(wxJSAPI-微信JSAPI支付,wxH5-微信H5支付,wxQrCode-微信二维码支付,alipayJSAPI-支付宝JSAPI支付,alipayPC-支付宝网站,alipayMobile-支付宝手机端,alipayPre-支付宝当面付)
     */
    @ApiField("payTypeCode")
    private String payTypeCode;
    /**
     * 业务单号
     */
    @ApiField("businessOrderNo")
    private String businessOrderNo;
    /**
     * 支付商品类型(0: 购买套餐；1：单合同签；2：支付收款合同款项；3：出证套餐)
     */
    @ApiField("goodsType")
    private Integer goodsType;
    /**
     * 商品名称
     */
    @ApiField("goodsName")
    private String goodsName;
    /**
     * 商品描述
     */
    @ApiField("goodsBody")
    private String goodsBody;
    /**
     * 支付金额
     */
    @ApiField("amount")
    private BigDecimal amount;
    /**
     * 支付状态: 0-订单生成, 1-支付中, 2-支付成功, 3-支付失败, 4-已退款
     */
    @ApiField("status")
    private Integer status;
    /**
     * 支付连接有效时间
     */
    @ApiField("expiredTime")
    private LocalDateTime expiredTime;
    /**
     * 支付成功时间
     */
    @ApiField("successTime")
    private LocalDateTime successTime;
    /**
     * 退订次数
     */
    @ApiField("refundTimes")
    private Integer refundTimes;
    /**
     * 退订金额
     */
    @ApiField("refundAmount")
    private BigDecimal refundAmount;
    /**
     * 备注
     */
    @ApiField("remark")
    private String remark;
    /**
     * 创建时间
     */
    @ApiField("createTime")
    private LocalDateTime createTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public Long getPsnId() {
        return psnId;
    }

    public void setPsnId(Long psnId) {
        this.psnId = psnId;
    }

    public String getPsnName() {
        return psnName;
    }

    public void setPsnName(String psnName) {
        this.psnName = psnName;
    }

    public Long getChannelModelId() {
        return channelModelId;
    }

    public void setChannelModelId(Long channelModelId) {
        this.channelModelId = channelModelId;
    }

    public String getProviderCode() {
        return providerCode;
    }

    public void setProviderCode(String providerCode) {
        this.providerCode = providerCode;
    }

    public String getPayTypeCode() {
        return payTypeCode;
    }

    public void setPayTypeCode(String payTypeCode) {
        this.payTypeCode = payTypeCode;
    }

    public String getBusinessOrderNo() {
        return businessOrderNo;
    }

    public void setBusinessOrderNo(String businessOrderNo) {
        this.businessOrderNo = businessOrderNo;
    }

    public Integer getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(Integer goodsType) {
        this.goodsType = goodsType;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getGoodsBody() {
        return goodsBody;
    }

    public void setGoodsBody(String goodsBody) {
        this.goodsBody = goodsBody;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public LocalDateTime getExpiredTime() {
        return expiredTime;
    }

    public void setExpiredTime(LocalDateTime expiredTime) {
        this.expiredTime = expiredTime;
    }

    public LocalDateTime getSuccessTime() {
        return successTime;
    }

    public void setSuccessTime(LocalDateTime successTime) {
        this.successTime = successTime;
    }

    public Integer getRefundTimes() {
        return refundTimes;
    }

    public void setRefundTimes(Integer refundTimes) {
        this.refundTimes = refundTimes;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
}
