package com.yunyinsign.api.sdk.result.member;

import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;

import java.time.LocalDateTime;


public class GetMemberInfoRes extends BaseResponse {

    /**
     * 用户ID
     */
    @ApiField("userId")
    private Long userId;
    /**
     * 用户编码
     */
    @ApiField("userCode")
    private String userCode;
    /**
     * 用户名称(昵称)
     */
    @ApiField("userName" )
    private String userName;
    /**
     * 手机
     */
    @ApiField("mobile")
    private String mobile;
    /**
     * 工号
     */
    @ApiField("jobNum")
    private String jobNum;
    /**
     * 用户状态（0：有效；1：无效）
     */
    @ApiField("userStatus")
    private Integer userStatus;
    /**
     * 真实姓名
     */
    @ApiField("realName")
    private String realName;
    /**
     * 身份证
     */
    @ApiField("identNum")
    private String identNum;
    /**
     * 实名状态
     */
    @ApiField("realNameStatus")
    private Integer realNameStatus;
    /**
     * 用户实名认证时方式： mobile: 实名手机号认证；face: 人脸识别认证；bank: 个人银行卡认证；offline: 人工审核认
     */
    @ApiField("identMethod")
    private String identMethod;
    /**
     * 身份验证通过时间
     */
    @ApiField("identSuccessTime")
    private LocalDateTime identSuccessTime;
    /**
     * 签署密码是否已设置(0:未设置,1:已设置)
     */
    @ApiField("signPwdSet")
    private Integer signPwdSet;
    /**
     * 创建时间
     */
    @ApiField("createTime")
    private LocalDateTime createTime;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getJobNum() {
        return jobNum;
    }

    public void setJobNum(String jobNum) {
        this.jobNum = jobNum;
    }

    public Integer getUserStatus() {
        return userStatus;
    }

    public void setUserStatus(Integer userStatus) {
        this.userStatus = userStatus;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getIdentNum() {
        return identNum;
    }

    public void setIdentNum(String identNum) {
        this.identNum = identNum;
    }

    public Integer getRealNameStatus() {
        return realNameStatus;
    }

    public void setRealNameStatus(Integer realNameStatus) {
        this.realNameStatus = realNameStatus;
    }

    public String getIdentMethod() {
        return identMethod;
    }

    public void setIdentMethod(String identMethod) {
        this.identMethod = identMethod;
    }

    public LocalDateTime getIdentSuccessTime() {
        return identSuccessTime;
    }

    public void setIdentSuccessTime(LocalDateTime identSuccessTime) {
        this.identSuccessTime = identSuccessTime;
    }

    public Integer getSignPwdSet() {
        return signPwdSet;
    }

    public void setSignPwdSet(Integer signPwdSet) {
        this.signPwdSet = signPwdSet;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
}
