package com.yunyinsign.api.sdk.result.corp;

import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;
import com.yunyinsign.api.sdk.result.member.GetUserStatusRes;

import java.time.LocalDateTime;


public class GetCorpBaseInfoRes extends BaseResponse {

    /**
     * 企业编码
     */
    @ApiField("corpCode")
    private String corpCode;
    /**
     * 企业名称
     */
    @ApiField("corpName")
    private String corpName;
    /**
     * 企业法定代表人名称
     */
    @ApiField("legalRepName")
    private String legalRepName;
    /**
     * 企业法定代表人证件号
     */
    @ApiField("legalRepIdentNo")
    private String legalRepIdentNo;
    /**
     * 认证状态： identified：已认证; unidentified：未认证; invalid：认证已失效
     */
    @ApiField("identStatus")
    private String identStatus;
    /**
     * 企业等级(0：普通会员；10：黑金会员VIP1；11：黑金会员VIP2；12：黑金会员VIP3)
     */
    @ApiField("corpLevel")
    private Integer corpLevel;
    /**
     * 黑金会员到期时间
     */
    @ApiField("levelExpireTime")
    private LocalDateTime levelExpireTime;
    /**
     * 收款单笔限额最大金额
     */
    @ApiField("maxAmount")
    private Integer maxAmount;
    /**
     * 合同份数余额
     */
    @ApiField("accountBalance")
    private Integer accountBalance;
    /**
     * 收款合同份数余额
     */
    @ApiField("payeeBalance")
    private Integer payeeBalance;
    /**
     * 企业员工数
     */
    @ApiField("userNum")
    private Integer userNum;
    /**
     * 企业注册时间
     */
    @ApiField("legalDate")
    private LocalDateTime legalDate;
    /**
     * 企业管理员账号  企业管理员名称
     */
    @ApiField("adminInfo")
    private GetUserStatusRes adminInfo;

    public String getCorpCode() {
        return corpCode;
    }
    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }
    public String getCorpName() {
        return corpName;
    }
    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }
    public String getLegalRepName() {
        return legalRepName;
    }

    public void setLegalRepName(String legalRepName) {
        this.legalRepName = legalRepName;
    }
    public String getLegalRepIdentNo() {
        return legalRepIdentNo;
    }
    public void setLegalRepIdentNo(String legalRepIdentNo) {
        this.legalRepIdentNo = legalRepIdentNo;
    }
    public String getIdentStatus() {
        return identStatus;
    }
    public void setIdentStatus(String identStatus) {
        this.identStatus = identStatus;
    }
    public Integer getCorpLevel() {
        return corpLevel;
    }
    public void setCorpLevel(Integer corpLevel) {
        this.corpLevel = corpLevel;
    }
    public LocalDateTime getLevelExpireTime() {
        return levelExpireTime;
    }
    public void setLevelExpireTime(LocalDateTime levelExpireTime) {
        this.levelExpireTime = levelExpireTime;
    }
    public Integer getMaxAmount() {
        return maxAmount;
    }
    public void setMaxAmount(Integer maxAmount) {
        this.maxAmount = maxAmount;
    }
    public Integer getAccountBalance() {
        return accountBalance;
    }
    public void setAccountBalance(Integer accountBalance) {
        this.accountBalance = accountBalance;
    }

    public Integer getPayeeBalance() {
        return payeeBalance;
    }

    public void setPayeeBalance(Integer payeeBalance) {
        this.payeeBalance = payeeBalance;
    }

    public Integer getUserNum() {
        return userNum;
    }

    public void setUserNum(Integer userNum) {
        this.userNum = userNum;
    }

    public LocalDateTime getLegalDate() {
        return legalDate;
    }

    public void setLegalDate(LocalDateTime legalDate) {
        this.legalDate = legalDate;
    }
    public GetUserStatusRes getAdminInfo() {
        return adminInfo;
    }
    public void setAdminInfo(GetUserStatusRes adminInfo) {
        this.adminInfo = adminInfo;
    }

}
