package com.yunyinsign.api.sdk.result.bill;

import com.yunyinsign.api.sdk.internal.mapping.ApiField;

import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * @author dyl
 */
public class GetSignFlowPayeeBillRes {

    /**
     * 消息ID
     */
    @ApiField("id")
    private Long id;
    /**
     * 流程编码
     */
    @ApiField("flowCode")
    private String flowCode;
    /**
     * 合同号
     */
    @ApiField("contractCode")
    private String contractCode;
    /**
     * 合同名称
     */
    @ApiField("contractName ")
    private String contractName;
    /**
     * 收款方企业名称
     */
    @ApiField("payeeCorpName")
    private String payeeCorpName;
    /**
     * 参与方id
     */
    @ApiField("participateId")
    private Long participateId;
    /**
     * 参与方类型 1-企业 0-个人
     */
    @ApiField("participantType")
    private Integer participantType;
    /**
     * 经办人名称
     */
    @ApiField("psnName")
    private String psnName;
    /**
     * 企业名称（个人类型时为空）
     */
    @ApiField("participantCorpName")
    private String participantCorpName;
    /**
     * 经办人手机
     */
    @ApiField("psnAccount")
    private String psnAccount;
    /**
     * 参与方式：1-填写 2-签署；用英文逗号分隔
     */
    @ApiField("participateBizType")
    private String participateBizType;
    /**
     * 金额
     */
    @ApiField("amount")
    private BigDecimal amount;
    /**
     * 支付单号
     */
    @ApiField("payOrderCode")
    private String payOrderCode;
    /**
     * 渠道单号
     */
    @ApiField("channelOrderNo")
    private String channelOrderNo;
    /**
     * 支付状态: 0-订单生成, 1-支付中, 2-支付成功, 3-支付失败, 4-已退款
     */
    @ApiField("payStatus")
    private Integer payStatus = 0;
    /**
     * 退款金额
     */
    @ApiField("refundAmount")
    private BigDecimal refundAmount = BigDecimal.ZERO;
    /**
     * 支付方式
     */
    @ApiField("providerCode")
    private String providerCode;
    /**
     * 创建时间
     */
    @ApiField("createTime")
    private LocalDateTime createTime;
    /**
     * 回调通知状态(0:无效回调；1：待回调；2： 已回调)
     */
    @ApiField("callbackStatus")
    private Integer callbackStatus=0;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFlowCode() {
        return flowCode;
    }

    public void setFlowCode(String flowCode) {
        this.flowCode = flowCode;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getPayeeCorpName() {
        return payeeCorpName;
    }

    public void setPayeeCorpName(String payeeCorpName) {
        this.payeeCorpName = payeeCorpName;
    }

    public Long getParticipateId() {
        return participateId;
    }

    public void setParticipateId(Long participateId) {
        this.participateId = participateId;
    }

    public Integer getParticipantType() {
        return participantType;
    }

    public void setParticipantType(Integer participantType) {
        this.participantType = participantType;
    }

    public String getPsnName() {
        return psnName;
    }

    public void setPsnName(String psnName) {
        this.psnName = psnName;
    }

    public String getParticipantCorpName() {
        return participantCorpName;
    }

    public void setParticipantCorpName(String participantCorpName) {
        this.participantCorpName = participantCorpName;
    }

    public String getPsnAccount() {
        return psnAccount;
    }

    public void setPsnAccount(String psnAccount) {
        this.psnAccount = psnAccount;
    }

    public String getParticipateBizType() {
        return participateBizType;
    }

    public void setParticipateBizType(String participateBizType) {
        this.participateBizType = participateBizType;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getPayOrderCode() {
        return payOrderCode;
    }

    public void setPayOrderCode(String payOrderCode) {
        this.payOrderCode = payOrderCode;
    }

    public String getChannelOrderNo() {
        return channelOrderNo;
    }

    public void setChannelOrderNo(String channelOrderNo) {
        this.channelOrderNo = channelOrderNo;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getProviderCode() {
        return providerCode;
    }

    public void setProviderCode(String providerCode) {
        this.providerCode = providerCode;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public Integer getCallbackStatus() {
        return callbackStatus;
    }

    public void setCallbackStatus(Integer callbackStatus) {
        this.callbackStatus = callbackStatus;
    }




}
