package com.yunyinsign.api.sdk.result;


import com.yunyinsign.api.sdk.internal.mapping.ApiField;


import java.io.Serializable;

/**
 * 模板组件特殊属性.
 *
 * @author
 */

public class TemplateCompSpecialAttr implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 日期格式： yyyy年MM月dd日 ; yyyy-MM-dd HH:mm:ss;yyyy-MM-dd
     */
    @ApiField("dateFormat")
    public String dateFormat;
    /**
     * 数字格式
     */
    @ApiField("numberFormat")
    public String numberFormat;

    /**
     * 小数位数
     */
    @ApiField("fractionDigits")
    public String fractionDigits;


    /**
     * 填充长度上限（多少个中文字符）
     */
    @ApiField("maxLength")
    public String maxLength;

    /**
     * 字体
     */
    @ApiField("font")
    public String font;

    /**
     * 字体大小
     */
    @ApiField("fontSize")
    public Integer fontSize;

    /**
     * 颜色
     */
    @ApiField("textColor")
    private String textColor;

    /**
     * 粗体
     */
    @ApiField("bold")
    private Boolean bold;

    /**
     * 斜体
     */
    @ApiField("italic")
    private boolean italic;

    /**
     * 下划线
     */
    @ApiField("underLine")
    private boolean underLine;

    /**
     * 中划线
     */
    @ApiField("lineThrough")
    private boolean lineThrough;

    /**
     * 对其方式
     */
    @ApiField("alignment")
    public int alignment;


    /*************** 前端定义属性  ***************/
    /**
     * 前端定义类型，类型 'mobileNumber'
     */
    @ApiField("type")
    private String type;
    /**
     * 图标
     */
    @ApiField("tagIcon")
    private String tagIcon;

    /**
     * 控件宽度（矩形的左右边距距离，单位为px）
     */
    @ApiField("width")
    private Integer width;

    /**
     * 控件高度（矩形的上下边距距离，单位为px）
     */
    @ApiField("height")
    private Integer height;

    @ApiField("order")
    private int order;


    /** ************ 签章数据 *******************************/
    /**
     * 是否显示签署日期: 0 - 不显示; 1 - 显示
     */
    @ApiField("showSignDate")
    public int showSignDate;

    /**
     * 签章区样式: 1-单页签章区； 2-骑缝签章区
     */
    @ApiField("signStyle")
    public Integer signStyle;

    /**
     * 落章规则: 1-以实际印章规格加盖； 2-自定义印章规格加盖（根据指定的签署区宽高适配
     */
    @ApiField("sealSpecs")
    public Integer sealSpecs;


    /**
     * 下拉选项
     */
    public static class Option {
        /**
         * 顺序
         */
        @ApiField("order")
        private int order;

        /**
         * 内容
         */
        @ApiField("content")
        private String content;

        /**
         * 是否选中
         */
        @ApiField("selected")
        private boolean selected;

        public int getOrder() {
            return order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean getSelected() {
            return selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }

    public String getDateFormat() {
        return dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getNumberFormat() {
        return numberFormat;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String getFractionDigits() {
        return fractionDigits;
    }

    public void setFractionDigits(String fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public String getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(String maxLength) {
        this.maxLength = maxLength;
    }

    public String getFont() {
        return font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public Integer getFontSize() {
        return fontSize;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public String getTextColor() {
        return textColor;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public Boolean getBold() {
        return bold;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public boolean getItalic() {
        return italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean getUnderLine() {
        return underLine;
    }

    public void setUnderLine(boolean underLine) {
        this.underLine = underLine;
    }

    public boolean getLineThrough() {
        return lineThrough;
    }

    public void setLineThrough(boolean lineThrough) {
        this.lineThrough = lineThrough;
    }

    public int getAlignment() {
        return alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTagIcon() {
        return tagIcon;
    }

    public void setTagIcon(String tagIcon) {
        this.tagIcon = tagIcon;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getShowSignDate() {
        return showSignDate;
    }

    public void setShowSignDate(int showSignDate) {
        this.showSignDate = showSignDate;
    }

    public Integer getSignStyle() {
        return signStyle;
    }

    public void setSignStyle(Integer signStyle) {
        this.signStyle = signStyle;
    }

    public Integer getSealSpecs() {
        return sealSpecs;
    }

    public void setSealSpecs(Integer sealSpecs) {
        this.sealSpecs = sealSpecs;
    }
}
