package com.yunyinsign.api.sdk.result;

import com.yunyinsign.api.sdk.BaseObject;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;

/**
 * OAuth2AccessToken
 *
 * @author
 * @date 2021/5/11
 */
public class OAuth2AccessToken extends BaseObject {
    /**
     * 令牌Token
     */
    @ApiField("accessToken")
    private String accessToken;
    /**
     * 企业id
     */
    @ApiField("corpId")
    private Long corpId;
    /**
     * 有效截止时间（秒）
     */
    @ApiField("expiresIn")
    private Integer expiresIn;

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public String toString() {
        return "OAuth2AccessToken{" +
                "accessToken='" + accessToken + '\'' +
                ", corpId=" + corpId +
                ", expiresIn=" + expiresIn +
                '}';
    }
}
