package com.yunyinsign.api.sdk.result;

import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;




import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

public class GetTemplateRes extends BaseResponse {

    /**
     * 模板ID
     */
    @ApiField("templateId")
    private Long templateId;
    /**
     * 企业名称
     */
    @ApiField("corpName")
    private String corpName;
    /**
     * 模板编码
     */
    @ApiField("templateCode")
    private String templateCode;
    /**
     * 模板名称
     */
    @ApiField("templateName")
    private String templateName;
    /**
     * 模板状态:0 - 停用状态; 1 - 启用状态
     */
    @ApiField("templateStatus")
    private Integer templateStatus;
    /**
     * 模板是否保密（0： 不保密；1：保密）
     */
    @ApiField("privaryFlag")
    private Integer privaryFlag;
    /**
     * 模板截至类型(0：不限；1：固定时长；2：模板指定)
     */
    @ApiField("expireType")
    private Integer expireType;
    /**
     * 模板满期时间
     */
    @ApiField("expireDate")
    private LocalDate expireDate;
    /**
     * 模板类型(0:个人；1：企业)
     */
    @ApiField("templateType")
    private Integer templateType;
    /**
     * 模板创建时间
     */
    @ApiField("createTime")
    private LocalDateTime createTime;
    /**
     * 模板更新时间
     */
    @ApiField("updateTime")
    private LocalDateTime updateTime;
    /**
     * 模板创建人
     */
    @ApiField("createName")
    private String createName;
    /**
     * 模板更新人
     */
    @ApiField("updateName")
    private String updateName;
    /**
     * 是否加密合同(0: 普通合同；1：加密合同)
     */
    @ApiField("encryptFlag")
    private Integer encryptFlag;
    /**
     * 是否收款合同（0：否；1：收款合同）
     */
    @ApiField("payeeContractFlag")
    private Integer payeeContractFlag;
//************** 公共模板信息 ******************/
    /**
     * 模板描述
     */
    @ApiField("templateDesc")
    private String templateDesc;
    /**
     * 排序(小优先级高)
     */
    @ApiField("templateSort")
    private Integer templateSort;
    /**
     * 模板分类
     */
    @ApiField("categoryId")
    private Long categoryId;
    /**
     * 是否公共模板
     */
    @ApiField("publicTemplate")
    private boolean publicTemplate;
    /**
     * 合同文件
     */
    @ApiField("contractFileList")
    private List<GetTemplateContractFileRes> contractFileList;
    /**
     * 参与方
     */
    @ApiField("participantList")
    private List<GetTemplateParticipantRes> participantList;
    /**
     * 组件
     */
    @ApiField("componentList")
    private List<GetTemplateComponentRes> componentList;
    /**
     * 抄送方
     */
    @ApiField("copierList")
    private List<GetTemplateCopierRes> copierList;
    /**
     * 附件
     */
    @ApiField("attachmentList")
    private List<GetTemplateAttachmentRes> attachmentList;

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Integer getTemplateStatus() {
        return templateStatus;
    }

    public void setTemplateStatus(Integer templateStatus) {
        this.templateStatus = templateStatus;
    }

    public Integer getPrivaryFlag() {
        return privaryFlag;
    }

    public void setPrivaryFlag(Integer privaryFlag) {
        this.privaryFlag = privaryFlag;
    }

    public Integer getExpireType() {
        return expireType;
    }

    public void setExpireType(Integer expireType) {
        this.expireType = expireType;
    }

    public LocalDate getExpireDate() {
        return expireDate;
    }

    public void setExpireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
    }

    public Integer getTemplateType() {
        return templateType;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }

    public Integer getEncryptFlag() {
        return encryptFlag;
    }

    public void setEncryptFlag(Integer encryptFlag) {
        this.encryptFlag = encryptFlag;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public String getTemplateDesc() {
        return templateDesc;
    }

    public void setTemplateDesc(String templateDesc) {
        this.templateDesc = templateDesc;
    }

    public Integer getTemplateSort() {
        return templateSort;
    }

    public void setTemplateSort(Integer templateSort) {
        this.templateSort = templateSort;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public boolean isPublicTemplate() {
        return publicTemplate;
    }

    public void setPublicTemplate(boolean publicTemplate) {
        this.publicTemplate = publicTemplate;
    }

    public List<GetTemplateContractFileRes> getContractFileList() {
        return contractFileList;
    }

    public void setContractFileList(List<GetTemplateContractFileRes> contractFileList) {
        this.contractFileList = contractFileList;
    }

    public List<GetTemplateParticipantRes> getParticipantList() {
        return participantList;
    }

    public void setParticipantList(List<GetTemplateParticipantRes> participantList) {
        this.participantList = participantList;
    }

    public List<GetTemplateComponentRes> getComponentList() {
        return componentList;
    }

    public void setComponentList(List<GetTemplateComponentRes> componentList) {
        this.componentList = componentList;
    }

    public List<GetTemplateCopierRes> getCopierList() {
        return copierList;
    }

    public void setCopierList(List<GetTemplateCopierRes> copierList) {
        this.copierList = copierList;
    }

    public List<GetTemplateAttachmentRes> getAttachmentList() {
        return attachmentList;
    }

    public void setAttachmentList(List<GetTemplateAttachmentRes> attachmentList) {
        this.attachmentList = attachmentList;
    }
}
