package com.yunyinsign.api.sdk.result;


import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;




import java.util.List;

public class GetTemplateParticipantRes extends BaseResponse {

    /**
     * 参与方ID
     */
    @ApiField("participantId")
    private Long participantId;
    /**
     * 模板ID
     */
    @ApiField("templateId")
    private Long templateId;
    /**
     * 参与方标识，同一个模板中不可重复， 会展示到模板页面上，例如甲方、乙方等容易理解的业务名词
     */
    @ApiField("participantFlag")
    private String participantFlag;
    /**
     * 参与方类型 1-企业 2-个人
     */
    @ApiField("participantType")
    private Integer participantType;
    /**
     * 参与方式：1-填写 2-签署
     */
    @ApiField("participateBizType")
    private List<String> participateBizType;
    /**
     * 参与方取值方式： 0-使用模版指定； 1- 固定成员； 3-发起人本人
     */
    @ApiField("participantSetMode")
    private Integer participantSetMode;
    /**
     * 参与方企业id（个人类型时为空）
     */
    @ApiField("participantCorpId")
    private Long participantCorpId;
    /**
     * 参与方企业名称（个人类型时为空）
     */
    @ApiField("participantCorpName")
    private String participantCorpName;
    /**
     * 经办人ID
     */
    @ApiField("psnId")
    private Long psnId;
    /**
     * 经办人手机
     */
    @ApiField("psnAccount")
    private String psnAccount;
    /**
     * 经办人名称
     */
    @ApiField("psnName")
    private String psnName;
    /**
     * 是否需要收款（0：否；1：是）
     */
    @ApiField("payeeContractFlag")
    private Integer payeeContractFlag;
    /**
     * 收款信息
     */
    @ApiField("payee")
    private GetTemplatePayeeRes payee;

    public Long getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getParticipantFlag() {
        return participantFlag;
    }

    public void setParticipantFlag(String participantFlag) {
        this.participantFlag = participantFlag;
    }

    public Integer getParticipantType() {
        return participantType;
    }

    public void setParticipantType(Integer participantType) {
        this.participantType = participantType;
    }

    public List<String> getParticipateBizType() {
        return participateBizType;
    }

    public void setParticipateBizType(List<String> participateBizType) {
        this.participateBizType = participateBizType;
    }

    public Integer getParticipantSetMode() {
        return participantSetMode;
    }

    public void setParticipantSetMode(Integer participantSetMode) {
        this.participantSetMode = participantSetMode;
    }

    public Long getParticipantCorpId() {
        return participantCorpId;
    }

    public void setParticipantCorpId(Long participantCorpId) {
        this.participantCorpId = participantCorpId;
    }

    public String getParticipantCorpName() {
        return participantCorpName;
    }

    public void setParticipantCorpName(String participantCorpName) {
        this.participantCorpName = participantCorpName;
    }

    public Long getPsnId() {
        return psnId;
    }

    public void setPsnId(Long psnId) {
        this.psnId = psnId;
    }

    public String getPsnAccount() {
        return psnAccount;
    }

    public void setPsnAccount(String psnAccount) {
        this.psnAccount = psnAccount;
    }

    public String getPsnName() {
        return psnName;
    }

    public void setPsnName(String psnName) {
        this.psnName = psnName;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public GetTemplatePayeeRes getPayee() {
        return payee;
    }

    public void setPayee(GetTemplatePayeeRes payee) {
        this.payee = payee;
    }
}
