package com.yunyinsign.api.sdk.result;

import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;




import java.math.BigDecimal;


public class GetTemplateComponentRes extends BaseResponse {
    /**
     * 组件ID
     */
    @ApiField("componentId")
    private Long componentId;
    /**
     * 模板ID
     */
    @ApiField("templateId")
    private Long templateId;
    /**
     * 参与方ID
     */
    @ApiField("participantId")
    private Long participantId;
    /**
     * 合同文档ID
     */
    @ApiField("contractFileId")
    private Long contractFileId;
    /**
     * 控件Key（设置文件模板时由用户自定义）
     */
    @ApiField("componentKey")
    private String componentKey;
    /**
     * 控件名称（设置文件模板时由用户自定义）
     */
    @ApiField("componentName")
    private String componentName;
    /**
     * 控件类型：1 - 单行文本，2 - 数字，3 - 日期，6 - 签章区域，8 - 多行文本，9 - 复选，10 - 单选，11 - 图片，14 -下拉框，15 - 勾选框，16 - 身份证，17 - 备注区域，18 - 动态表格，19 - 手机号
     */
    @ApiField("componentType")
    private Integer componentType;
    /**
     * 控件默认值（页面中文本控件或数字控件中设置的默认值）
     */
    @ApiField("value")
    private String value;
    /**
     * 控件是否必填：1 - 必填；0- 非必填
     */
    @ApiField("required")
    private Integer required;
    /**
     * 控件X横坐标
     */
    @ApiField("positionX")
    private BigDecimal positionX;
    /**
     * 控件Y纵坐标值
     */
    @ApiField("positionY")
    private BigDecimal positionY;
    /**
     * 当前控件所在页码
     */
    @ApiField("pageNum")
    private Integer pageNum;


    /**
     * 控件特有属性：{"dateFormat": "日期格式yyyy-MM-dd HH:mm:ss","imageType":"图片类型:IDCard_widthwise（身份证横向等比缩放大小）;IDCard_longitudinal（身份证纵向等比缩放大小）;other （其他，自由缩放大小）","tableContent":[{"表格行列内容（动态表格控件特有），格式： [row{"column1":"value1","column2":"value2"}]}
     */
    @ApiField("specialAttribute")
    private TemplateCompSpecialAttr specialAttribute;

    public Long getComponentId() {
        return componentId;
    }

    public void setComponentId(Long componentId) {
        this.componentId = componentId;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Long getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public String getComponentKey() {
        return componentKey;
    }

    public void setComponentKey(String componentKey) {
        this.componentKey = componentKey;
    }

    public String getComponentName() {
        return componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public Integer getComponentType() {
        return componentType;
    }

    public void setComponentType(Integer componentType) {
        this.componentType = componentType;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getRequired() {
        return required;
    }

    public void setRequired(Integer required) {
        this.required = required;
    }

    public BigDecimal getPositionX() {
        return positionX;
    }

    public void setPositionX(BigDecimal positionX) {
        this.positionX = positionX;
    }

    public BigDecimal getPositionY() {
        return positionY;
    }

    public void setPositionY(BigDecimal positionY) {
        this.positionY = positionY;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public TemplateCompSpecialAttr getSpecialAttribute() {
        return specialAttribute;
    }

    public void setSpecialAttribute(TemplateCompSpecialAttr specialAttribute) {
        this.specialAttribute = specialAttribute;
    }
}
