package com.yunyinsign.api.sdk.result;

import com.yunyinsign.api.sdk.core.BaseResponse;
import com.yunyinsign.api.sdk.internal.mapping.ApiField;




import java.util.List;

public class GetParticipantInfoRes extends BaseResponse {

    /**
     * 参与方ID
     */
    @ApiField("participantId")
    private Long participantId;
    /**
     * 参与方标识
     */
    @ApiField("participantFlag")
    private String participantFlag;
    /**
     * 参与方类型 1-企业 0-个人
     */
    @ApiField("participantType")
    private Integer participantType;
    /**
     * 参与方式：1-填写 2-签署；用英文逗号分隔
     */
    @ApiField("participateBizType")
    private List<String> participateBizType;
    /**
     * 经办人名称
     */
    @ApiField("psnName")
    private String psnName;
    /**
     * 经办人手机
     */
    @ApiField("psnAccount")
    private String psnAccount;
    /**
     * 企业名称（个人类型时为空）
     */
    @ApiField("participantCorpName")
    private String participantCorpName;

    public Long getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public String getParticipantFlag() {
        return participantFlag;
    }

    public void setParticipantFlag(String participantFlag) {
        this.participantFlag = participantFlag;
    }

    public Integer getParticipantType() {
        return participantType;
    }

    public void setParticipantType(Integer participantType) {
        this.participantType = participantType;
    }

    public List<String> getParticipateBizType() {
        return participateBizType;
    }

    public void setParticipateBizType(List<String> participateBizType) {
        this.participateBizType = participateBizType;
    }

    public String getPsnName() {
        return psnName;
    }

    public void setPsnName(String psnName) {
        this.psnName = psnName;
    }

    public String getPsnAccount() {
        return psnAccount;
    }

    public void setPsnAccount(String psnAccount) {
        this.psnAccount = psnAccount;
    }

    public String getParticipantCorpName() {
        return participantCorpName;
    }

    public void setParticipantCorpName(String participantCorpName) {
        this.participantCorpName = participantCorpName;
    }
}
