package com.yunyinsign.api.sdk.request.template;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseFileUploadRequest;
import com.yunyinsign.api.sdk.response.template.UploadContractFileResponse;

/**
 * @author dyl
 * 上传模板合同文件
 */
public class UploadContractFileReq extends BaseFileUploadRequest<UploadContractFileResponse> {

    @Override
    public String getApiPath() {
        return "/template/uploadContractFile";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<UploadContractFileResponse> getResponseType() {
        return UploadContractFileResponse.class;
    }

    public static UploadContractFileReq create(byte[] fileBytes, String fileName) {
        UploadContractFileReq request = new UploadContractFileReq();
        request.setFileBytes(fileBytes);
        request.setFileName(fileName);
        return request;
    }
}
