package com.yunyinsign.api.sdk.request.template;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseFileUploadRequest;
import com.yunyinsign.api.sdk.response.template.UploadAttachmentFileResponse;
import com.yunyinsign.api.sdk.result.template.AttachmentFileUploadRes;

/**
 * @author dyl
 * 上传模板附件文件
 */
public class UploadAttachmentFileReq extends BaseFileUploadRequest<UploadAttachmentFileResponse> {

    @Override
    public String getApiPath() {
        return "/template/uploadAttachmentFile";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<UploadAttachmentFileResponse> getResponseType() {
        return UploadAttachmentFileResponse.class;
    }

    public static UploadAttachmentFileReq create(byte[] fileBytes, String fileName) {
        UploadAttachmentFileReq request = new UploadAttachmentFileReq();
        request.setFileBytes(fileBytes);
        request.setFileName(fileName);
        return request;
    }
}
