package com.yunyinsign.api.sdk.request.template;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.model.vo.GetTemplateAttachmentReq;
import com.yunyinsign.api.sdk.model.vo.GetTemplateContractFileReq;
import com.yunyinsign.api.sdk.model.vo.GetTemplateParticipantReq;
import com.yunyinsign.api.sdk.response.template.TemplateModifyResponse;

import java.util.List;

/**
 * @author dyl
 * 更新模板详情
 */
public class TemplateModifyReq extends BaseRequest<TemplateModifyResponse> {

    @Override
    public String getApiPath() {
        return "/template/modifyTemplate";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<TemplateModifyResponse> getResponseType() {
        return TemplateModifyResponse.class;
    }

    @RequestField("模板ID. 编辑时传，新增不用传")
    private Long templateId;

    @RequestField("模板名称")
    private String templateName;

    @RequestField("直接发起合同标识(0： 非直接发起；1：直接发起草稿状态；2：直接发起临时文件，后面可以删除)")
    private Integer directStatus;
    /**
     * 是否加密合同(0: 普通合同；1：加密合同)
     */
    @RequestField("是否加密合同(0: 普通合同；1：加密合同)")
    private Integer encryptFlag;

    /**
     * 是否对方付（0：发起方付；1：对方付）
     */
    @RequestField("是否对方付（0：发起方付；1：对方付")
    private Integer reversePayFlag;

    /**
     * 是否收款合同（0：否；1：收款合同）
     */
    @RequestField("是否收款合同（0：否；1：收款合同）")
    private Integer payeeContractFlag;

    /**
     * 设置签署方
     */
    @RequestField("签署方")
    private List<GetTemplateParticipantReq> participantList;

    /**
     * 合同文件
     */
    @RequestField("合同文件")
    private List<GetTemplateContractFileReq> contractFileList;

    /**
     * 选填项设置.合同附件
     */
    @RequestField("附件")
    private List<GetTemplateAttachmentReq> attachmentList;


    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Integer getDirectStatus() {
        return directStatus;
    }

    public void setDirectStatus(Integer directStatus) {
        this.directStatus = directStatus;
    }

    public Integer getEncryptFlag() {
        return encryptFlag;
    }

    public void setEncryptFlag(Integer encryptFlag) {
        this.encryptFlag = encryptFlag;
    }

    public Integer getReversePayFlag() {
        return reversePayFlag;
    }

    public void setReversePayFlag(Integer reversePayFlag) {
        this.reversePayFlag = reversePayFlag;
    }

    public Integer getPayeeContractFlag() {
        return payeeContractFlag;
    }

    public void setPayeeContractFlag(Integer payeeContractFlag) {
        this.payeeContractFlag = payeeContractFlag;
    }

    public List<GetTemplateParticipantReq> getParticipantList() {
        return participantList;
    }

    public void setParticipantList(List<GetTemplateParticipantReq> participantList) {
        this.participantList = participantList;
    }

    public List<GetTemplateContractFileReq> getContractFileList() {
        return contractFileList;
    }

    public void setContractFileList(List<GetTemplateContractFileReq> contractFileList) {
        this.contractFileList = contractFileList;
    }

    public List<GetTemplateAttachmentReq> getAttachmentList() {
        return attachmentList;
    }

    public void setAttachmentList(List<GetTemplateAttachmentReq> attachmentList) {
        this.attachmentList = attachmentList;
    }
}
