package com.yunyinsign.api.sdk.request.template;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.template.TemplateInfoQueryResponse;

/**
 * @author dyl
 * 模板详情查询
 */
public class TemplateInfoQueryReq extends BaseRequest<TemplateInfoQueryResponse> {

    @Override
    public String getApiPath() {
        return "/template/info";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<TemplateInfoQueryResponse> getResponseType() {
        return TemplateInfoQueryResponse.class;
    }

    @RequestField("模板ID")
    private Long templateId;

    @RequestField("查询类型(1-编辑模板时查询详情；2-模板使用时查询详情)")
    private String templateType;


    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getTemplateType() {
        return templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }
}
