package com.yunyinsign.api.sdk.request.template;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.template.TemplateIdResponse;

/**
 * @author dyl
 * 查询模板控件信息
 */
public class TemplateIdReq extends BaseRequest<TemplateIdResponse> {

    @Override
    public String getApiPath() {
        return "/template/componentInfoList";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<TemplateIdResponse> getResponseType() {
        return TemplateIdResponse.class;
    }

    @RequestField("模板ID")
    private Long templateId;

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }
}
