package com.yunyinsign.api.sdk.request.template;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.model.vo.TemplateComponentReq;
import com.yunyinsign.api.sdk.response.template.TemplateComponentModifyResponse;

import java.util.List;

/**
 * @author dyl
 * 保存编辑模板控件设置
 */
public class TemplateComponentModifyReq extends BaseRequest<TemplateComponentModifyResponse> {

    @Override
    public String getApiPath() {
        return "/template/modifyComponent";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<TemplateComponentModifyResponse> getResponseType() {
        return TemplateComponentModifyResponse.class;
    }

    @RequestField(value = "模板ID")
    private Long templateId;

    /**
     * 组件列表
     */
    @RequestField(value = "控件列表")
    public List<TemplateComponentReq> components;


    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public List<TemplateComponentReq> getComponents() {
        return components;
    }

    public void setComponents(List<TemplateComponentReq> components) {
        this.components = components;
    }
}
