package com.yunyinsign.api.sdk.request.template;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.model.vo.TemplateComponentReq;
import com.yunyinsign.api.sdk.response.template.TemplateComponentCreateResponse;

import java.util.List;

/**
 * @author dyl
 * 保存新增模板控件设置
 */
public class TemplateComponentCreateReq extends BaseRequest<TemplateComponentCreateResponse> {

    @Override
    public String getApiPath() {
        return "/template/addComponent";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<TemplateComponentCreateResponse> getResponseType() {
        return TemplateComponentCreateResponse.class;
    }

    @RequestField(value = "模板ID")
    private Long templateId;

    /**
     * 组件列表
     */
    @RequestField(value = "控件列表")
    public List<TemplateComponentReq> components;


    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public List<TemplateComponentReq> getComponents() {
        return components;
    }

    public void setComponents(List<TemplateComponentReq> components) {
        this.components = components;
    }
}
