package com.yunyinsign.api.sdk.request.template;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.template.GetTemplateUpdateStatusResponse;

/**
 * @author dyl
 * 启用/停用模板
 */
public class GetTemplateUpdateStatusReq extends BaseRequest<GetTemplateUpdateStatusResponse> {

    @Override
    public String getApiPath() {
        return "/template/updateStatus";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetTemplateUpdateStatusResponse> getResponseType() {
        return GetTemplateUpdateStatusResponse.class;
    }

    @RequestField("模板ID")
    private Long templateId;

    @RequestField("模板状态:0 - 停用状态; 1 - 启用状态")
    private Integer templateStatus;

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Integer getTemplateStatus() {
        return templateStatus;
    }

    public void setTemplateStatus(Integer templateStatus) {
        this.templateStatus = templateStatus;
    }
}
