package com.yunyinsign.api.sdk.request.template;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BasePageRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.template.GetTemplateQueryResponse;

/**
 * @author dyl
 * 模板列表查询
 */
public class GetTemplateQueryReq extends BasePageRequest<GetTemplateQueryResponse> {

    @Override
    public String getApiPath() {
        return "/template/list";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetTemplateQueryResponse> getResponseType() {
        return GetTemplateQueryResponse.class;
    }

    @RequestField("模板ID")
    private Long templateId;

    @RequestField("模板名称")
    private String templateName;

    @RequestField("模板状态:0 - 停用状态; 1 - 启用状态")
    private Integer templateStatus;

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Integer getTemplateStatus() {
        return templateStatus;
    }

    public void setTemplateStatus(Integer templateStatus) {
        this.templateStatus = templateStatus;
    }
}
