package com.yunyinsign.api.sdk.request.template;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.template.GetTemplateEditeUrlResponse;

/**
 * @author dyl
 * 获取模板编辑链接
 */
public class GetTemplateEditeUrlReq extends BaseRequest<GetTemplateEditeUrlResponse> {

    @Override
    public String getApiPath() {
        return "/template/getTemplateEditeUrl";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetTemplateEditeUrlResponse> getResponseType() {
        return GetTemplateEditeUrlResponse.class;
    }

    @RequestField("模板ID")
    private Long templateId;

    @RequestField("模板类型")
    private Integer templateType;

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Integer getTemplateType() {
        return templateType;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }
}
