package com.yunyinsign.api.sdk.request.template;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.template.GetTemplateDelResponse;

/**
 * @author dyl
 * 删除模板
 */
public class GetTemplateDelReq extends BaseRequest<GetTemplateDelResponse> {

    @Override
    public String getApiPath() {
        return "/template/del";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetTemplateDelResponse> getResponseType() {
        return GetTemplateDelResponse.class;
    }

    @RequestField("模板ID")
    private Long templateId;


    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

}
