package com.yunyinsign.api.sdk.request.sms;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sms.SendSmsResponse;

/**
 * @author dyl
 * 发送短信验证码
 */
public class SendSmsReq extends BaseRequest<SendSmsResponse> {

    @Override
    public String getApiPath() {
        return "/sms/sendSmsVerifyCode";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<SendSmsResponse> getResponseType() {
        return SendSmsResponse.class;
    }

    @RequestField("手机号码")
    private String mobile;

    @RequestField("短信发送类型 commSms-注册登录 sign-合同签署 approval-合同审批 signPwd-修改签署密码")
    private String smsType;

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getSmsType() {
        return smsType;
    }

    public void setSmsType(String smsType) {
        this.smsType = smsType;
    }
}
