package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.SignFlowApprovalVerifyResponse;

/**
 * @author dyl
 * 审批合同用章短信/密码认证回调方法
 */
public class SignFlowApprovalVerifyReq extends BaseRequest<SignFlowApprovalVerifyResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/approvalSignAuth";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<SignFlowApprovalVerifyResponse> getResponseType() {
        return SignFlowApprovalVerifyResponse.class;
    }


    @RequestField(value="审批申请id")
    private String approvalId;

    @RequestField(value="认证方式: sms:短信；pwd:密码； face:刷脸")
    private String authType;

    @RequestField(value="验证码")
    private String verifyCode;

    @RequestField(value="签署密码")
    private String signPwd;

    @RequestField(value="是否是新设置签署密码(true：是； false： 不是)")
    private boolean newPwd;

    @RequestField(value="人脸核身结果的返回码，0 表示人脸核身成功，其他错误码标识失败。")
    private String code;

    @RequestField(value="订单号 ，由合作方上传，每次唯一，此信息为本次人脸核身上传的信息。")
    private String orderNo;

    @RequestField(value="本次请求返回的唯一标识，此信息为本次人脸核身上传的信息")
    private String h5faceId;

    @RequestField(value="对 URL 参数 App ID、orderNo 和 SIGN ticket、code 的签名。详细签名验证步骤见下面说明步骤")
    private String newSign;

    @RequestField(value="对 URL 参数 App ID、orderNo 和 SIGN ticket、code 的签名。详细签名验证步骤见下面说明步骤")
    private String newSignature;

    public String getApprovalId() {
        return approvalId;
    }

    public void setApprovalId(String approvalId) {
        this.approvalId = approvalId;
    }

    public String getAuthType() {
        return authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getVerifyCode() {
        return verifyCode;
    }

    public void setVerifyCode(String verifyCode) {
        this.verifyCode = verifyCode;
    }

    public String getSignPwd() {
        return signPwd;
    }

    public void setSignPwd(String signPwd) {
        this.signPwd = signPwd;
    }

    public boolean isNewPwd() {
        return newPwd;
    }

    public void setNewPwd(boolean newPwd) {
        this.newPwd = newPwd;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getH5faceId() {
        return h5faceId;
    }

    public void setH5faceId(String h5faceId) {
        this.h5faceId = h5faceId;
    }

    public String getNewSign() {
        return newSign;
    }

    public void setNewSign(String newSign) {
        this.newSign = newSign;
    }

    public String getNewSignature() {
        return newSignature;
    }

    public void setNewSignature(String newSignature) {
        this.newSignature = newSignature;
    }
}
