package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.model.vo.GetStartSignFlowComponentReq;
import com.yunyinsign.api.sdk.model.vo.GetStartSignFlowParticipantReq;
import com.yunyinsign.api.sdk.model.vo.GetTemplateAttachmentReq;
import com.yunyinsign.api.sdk.response.sign.GetStartSignFlowResponse;

import java.util.List;

/**
 * @author dyl
 * 模板发起合同流程
 */
public class GetStartSignFlowReq extends BaseRequest<GetStartSignFlowResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/startSignFlow";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetStartSignFlowResponse> getResponseType() {
        return GetStartSignFlowResponse.class;
    }

    @RequestField(value="模板ID（模板id和模板编码二选一）")
    private Long templateId;

    @RequestField(value="模板编码（模板id和模板编码二选一）")
    private String templateCode;

    @RequestField(value="模板名称")
    private String templateName;

    @RequestField(value="模板是否保密（0： 不保密；1：保密）")
    private Integer privaryFlag;

    @RequestField(value="是否加密合同(0: 普通合同；1：加密合同)")
    private Integer encryptFlag;

    @RequestField(value="是否对方付（0：发起方付；1：对方付）")
    private Integer reversePayFlag;

    @RequestField(value = "签署流程类型(0：正常签署流程；1：批次签署流程；2: 临时流程,对方通过小程序登录后可以更换手机号)， 默认0")
    private Integer flowType;

    @RequestField(value="外部单号(企业app过来的可以保留一个外部来源单号)")
    private String sourceOrderCode;

    @RequestField(value="设置签署方")
    private List<GetStartSignFlowParticipantReq> participantList;

    @RequestField(value="选填项设置.合同附件")
    private List<GetTemplateAttachmentReq> attachmentList;

    @RequestField(value="自动填写标识（0：不自动填写；1：异步自动填写；2：同步自动填写），默认0")
    private Integer autoFill;

    @RequestField(value="自动填写信息 (填写应设置模板所属企业签署方填写，不要设成对方填写)")
    private List<GetStartSignFlowComponentReq> fillComponents;

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Integer getPrivaryFlag() {
        return privaryFlag;
    }

    public void setPrivaryFlag(Integer privaryFlag) {
        this.privaryFlag = privaryFlag;
    }

    public Integer getEncryptFlag() {
        return encryptFlag;
    }

    public void setEncryptFlag(Integer encryptFlag) {
        this.encryptFlag = encryptFlag;
    }

    public Integer getReversePayFlag() {
        return reversePayFlag;
    }

    public void setReversePayFlag(Integer reversePayFlag) {
        this.reversePayFlag = reversePayFlag;
    }

    public Integer getFlowType() {
        return flowType;
    }

    public void setFlowType(Integer flowType) {
        this.flowType = flowType;
    }

    public String getSourceOrderCode() {
        return sourceOrderCode;
    }

    public void setSourceOrderCode(String sourceOrderCode) {
        this.sourceOrderCode = sourceOrderCode;
    }

    public List<GetStartSignFlowParticipantReq> getParticipantList() {
        return participantList;
    }

    public void setParticipantList(List<GetStartSignFlowParticipantReq> participantList) {
        this.participantList = participantList;
    }

    public List<GetTemplateAttachmentReq> getAttachmentList() {
        return attachmentList;
    }

    public void setAttachmentList(List<GetTemplateAttachmentReq> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public Integer getAutoFill() {
        return autoFill;
    }

    public void setAutoFill(Integer autoFill) {
        this.autoFill = autoFill;
    }

    public List<GetStartSignFlowComponentReq> getFillComponents() {
        return fillComponents;
    }

    public void setFillComponents(List<GetStartSignFlowComponentReq> fillComponents) {
        this.fillComponents = fillComponents;
    }
}
