package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.model.vo.GetTemplateAttachmentReq;
import com.yunyinsign.api.sdk.model.vo.GetTemplateComponentReq;
import com.yunyinsign.api.sdk.model.vo.GetTemplateContractFileReq;
import com.yunyinsign.api.sdk.model.vo.GetTemplateParticipantReq;
import com.yunyinsign.api.sdk.response.sign.GetStartFlowTemplateResponse;

import java.util.List;

/**
 * @author dyl
 * 直接发起合同
 */
public class GetStartFlowTemplateReq extends BaseRequest<GetStartFlowTemplateResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/directSignFlow";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetStartFlowTemplateResponse> getResponseType() {
        return GetStartFlowTemplateResponse.class;
    }


    @RequestField(value="模板ID")
    private Long templateId;

    @RequestField(value="模板名称")
    private String templateName;

    @RequestField(value="模板是否保密（0： 不保密；1：保密）")
    private Integer privaryFlag;

    @RequestField(value="是否加密合同(0: 普通合同；1：加密合同)")
    private Integer encryptFlag;

    @RequestField(value="是否对方付（0：发起方付；1：对方付）")
    private Integer reversePayFlag;
    @RequestField(value="外部单号(企业app过来的可以保留一个外部来源单号)")
    private String sourceOrderCode;

    @RequestField(value="设置签署方")
    private List<GetTemplateParticipantReq> participantList;

    @RequestField(value="合同文件")
    private List<GetTemplateContractFileReq> contractFileList;

    @RequestField(value="选填项设置.合同附件")
    private List<GetTemplateAttachmentReq> attachmentList;

    @RequestField(value="模板组件")
    private GetTemplateComponentReq component;

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Integer getPrivaryFlag() {
        return privaryFlag;
    }

    public void setPrivaryFlag(Integer privaryFlag) {
        this.privaryFlag = privaryFlag;
    }

    public Integer getEncryptFlag() {
        return encryptFlag;
    }

    public void setEncryptFlag(Integer encryptFlag) {
        this.encryptFlag = encryptFlag;
    }

    public Integer getReversePayFlag() {
        return reversePayFlag;
    }

    public void setReversePayFlag(Integer reversePayFlag) {
        this.reversePayFlag = reversePayFlag;
    }

    public String getSourceOrderCode() {
        return sourceOrderCode;
    }

    public void setSourceOrderCode(String sourceOrderCode) {
        this.sourceOrderCode = sourceOrderCode;
    }

    public List<GetTemplateParticipantReq> getParticipantList() {
        return participantList;
    }

    public void setParticipantList(List<GetTemplateParticipantReq> participantList) {
        this.participantList = participantList;
    }

    public List<GetTemplateContractFileReq> getContractFileList() {
        return contractFileList;
    }

    public void setContractFileList(List<GetTemplateContractFileReq> contractFileList) {
        this.contractFileList = contractFileList;
    }

    public List<GetTemplateAttachmentReq> getAttachmentList() {
        return attachmentList;
    }

    public void setAttachmentList(List<GetTemplateAttachmentReq> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public GetTemplateComponentReq getComponent() {
        return component;
    }

    public void setComponent(GetTemplateComponentReq component) {
        this.component = component;
    }
}
