package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignerPayInfoResponse;

/**
 * @author dyl
 * 收款合同根据参与方查付款信息
 */
public class GetSignerPayInfoReq extends BaseRequest<GetSignerPayInfoResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/signerPayInfo";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignerPayInfoResponse> getResponseType() {
        return GetSignerPayInfoResponse.class;
    }

    @RequestField(value="流程编码")
    private Long flowId;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }
}
