package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowTaskInfoResponse;

/**
 * @author dyl
 * 合同单条详情信息任务信息
 */
public class GetSignFlowTaskInfoReq extends BaseRequest<GetSignFlowTaskInfoResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/contract/taskInfo";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowTaskInfoResponse> getResponseType() {
        return GetSignFlowTaskInfoResponse.class;
    }


    @RequestField(value="流程ID")
    private Long flowId;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }
}
