package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowStrIdResponse;

/**
 * @author dyl
 * 分享链接查询合同封面(基本信息)
 */
public class GetSignFlowStrIdReq extends BaseRequest<GetSignFlowStrIdResponse> {

    @Override
    public String getApiPath() {
        return "/signTask/signerFlowCoverInfo";
    }

    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowStrIdResponse> getResponseType() {
        return GetSignFlowStrIdResponse.class;
    }


    @RequestField(value="流程编码")
    private String flowId;

    public String getFlowId() {
        return flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }
}
