package com.yunyinsign.api.sdk.request.sign;

import com.yunyinsign.api.sdk.constants.RequestConstants;
import com.yunyinsign.api.sdk.core.BaseRequest;
import com.yunyinsign.api.sdk.internal.mapping.RequestField;
import com.yunyinsign.api.sdk.response.sign.GetSignFlowParticipantResponse;

/**
 * @author dyl
 * 根据合同参与方跳转小程序
 */
public class GetSignFlowParticipantReq extends BaseRequest<GetSignFlowParticipantResponse> {


    /**
     * 获取API路径
     */
    @Override
    public String getApiPath() {
        return "/signTask/contract/appletForParticipant";
    }

    /**
     * 获取HTTP方法
     */
    @Override
    public String getHttpMethod() {
        return RequestConstants.METHOD_POST;
    }

    /**
     * 获取响应类型引用
     */
    @Override
    public Class<GetSignFlowParticipantResponse> getResponseType() {
        return GetSignFlowParticipantResponse.class;
    }

    @RequestField(value="签署方信息ID")
    private Long participantId;

    @RequestField(value="类型：0-微信，1-支付宝")
    private Integer type;

    public Long getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
